/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.core.MaltegoEntity;

public abstract class AbstractFilter
extends AbstractAction {
    private final boolean _evaluateLazily;

    public AbstractFilter(String name) {
        this(name, true);
    }

    public AbstractFilter(String name, boolean evaluateLazily) {
        super(name);
        this._evaluateLazily = evaluateLazily;
    }

    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        if (this.useWholeGraphAsInput()) {
            payload = Payloads.all(ctx.getTargetGraphID());
        }
        payload = this.createFilteredPayload(ctx, payload);
        payload = this.limitEntities(payload);
        if (!this._evaluateLazily) {
            payload = Payloads.clone(payload);
        }
        cb.completed(payload);
    }

    public Payload limitEntities(Payload payload) {
        return Payloads.filtered(payload, new LimitEntityFilter((Integer)this.getProperty("limit", -1)));
    }

    public boolean useWholeGraphAsInput() {
        Object scope = this.getProperty("scope", "local");
        return "global".equals(scope);
    }

    protected abstract Payload createFilteredPayload(AutomationContext var1, Payload var2);

    private class LimitEntityFilter
    implements Payloads.EntityFilter {
        private final int _limit;
        private int _count = 0;

        public LimitEntityFilter(int limit) {
            this._limit = limit;
        }

        @Override
        public boolean include(MaltegoEntity entity) {
            boolean include = false;
            if (this._limit == -1) {
                include = true;
            } else if (this._count < this._limit) {
                ++this._count;
                include = true;
            }
            return include;
        }
    }
}

