/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.controls.DateRangePicker;
import com.paterva.maltego.typing.types.DateRange;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class DateRangePropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private final DateRangePicker _control = new DateRangePicker();
    private DateRange _initPopupDateRange;
    private DateRange _updatingPopupDateRange;
    private PropertyEnv _env;

    private DateRangePropertyEditor() {
        this(null, null);
    }

    public DateRangePropertyEditor(DisplayDescriptor descriptor, DataSource data) {
        if (descriptor != null && data != null) {
            Object value = data.getValue((PropertyDescriptor)descriptor);
            if (value != null && value instanceof String) {
                DateRange parseDateRange = DateRange.parse((String)((String)value));
                if (parseDateRange != null) {
                    this.getEditorControl().setDateRange(parseDateRange);
                }
            } else if (value != null && value instanceof DateRange) {
                this.getEditorControl().setDateRange((DateRange)value);
            }
        }
        this._initPopupDateRange = this.getEditorControl().getDateRange();
        this._updatingPopupDateRange = this.getEditorControl().getDateRange();
        this._control.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("DateRangeChanged".equals(e.getActionCommand())) {
                    DateRangePropertyEditor.this._updatingPopupDateRange = DateRangePropertyEditor.this.getEditorControl().getDateRange();
                }
            }
        });
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (!this._initPopupDateRange.isCopyEquals((Object)this._updatingPopupDateRange)) {
            this._updatingPopupDateRange = DateRange.createCopy((DateRange)this._initPopupDateRange);
            this.getEditorControl().setDateRange(this._initPopupDateRange);
        }
        JPanel popupContent = this.getEditorControl().getPopupPanel();
        int[] popupContentHeight = this.getEditorControl().getPopupPanelHeight();
        Dimension contentSize = popupContent.getPreferredSize();
        if (popupContentHeight[0] == -1) {
            popupContentHeight[0] = contentSize.height;
        } else {
            contentSize.height = popupContentHeight[0];
            popupContent.setPreferredSize(contentSize);
        }
        popupContent.firePropertyChange("popupContentShown", false, true);
        return popupContent;
    }

    public void attachEnv(PropertyEnv env) {
        this._env = env;
        this._env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        this._env.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("state".equals(evt.getPropertyName())) {
                    DateRangePropertyEditor.this._initPopupDateRange = DateRange.createCopy((DateRange)DateRangePropertyEditor.this._updatingPopupDateRange);
                    DateRangePropertyEditor.this.setValueInternal(DateRangePropertyEditor.this._initPopupDateRange);
                }
            }
        });
    }

    @Override
    public String getAsText() {
        return this._initPopupDateRange.toString();
    }

    @Override
    public Object getValue() {
        DateRange oldDateRange = this.getEditorControl().getDateRange();
        DateRange newDateRange = oldDateRange != null ? DateRange.createCopy((DateRange)oldDateRange) : null;
        return newDateRange;
    }

    @Override
    public void setValue(Object object) {
        DateRange oldDateRange = (DateRange)object;
        DateRange newDateRange = oldDateRange != null ? DateRange.createCopy((DateRange)oldDateRange) : null;
        this.getEditorControl().setDateRange(newDateRange);
    }

    private DateRangePicker getEditorControl() {
        return this._control;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public void firePropertyChange() {
        super.firePropertyChange();
    }

    protected void setValueInternal(DateRange dateRange) {
        super.setValue(dateRange);
    }
}

