/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ChangeSupport;

public abstract class AbstractControlAdapter<TComponent extends Component, TType>
implements ControlAdapter {
    private ChangeSupport _changeSupport;
    private EventListenerList _listeners;
    private Color _defaultBackground;
    public static final String EDITING_FINISHED = "EditingFinished";
    private Color _errorColor = UIManager.getLookAndFeelDefaults().getColor("7-red");
    private boolean _useErrorColor = true;

    @Override
    public void addActionListener(ActionListener listener) {
        this.listeners().add(ActionListener.class, listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.listeners().remove(ActionListener.class, listener);
    }

    private EventListenerList listeners() {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        return this._listeners;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport().addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport().removeChangeListener(listener);
    }

    protected void fireChange() {
        if (this._changeSupport != null) {
            this._changeSupport.fireChange();
        }
    }

    protected void fireActionPerformed(ActionEvent event) {
        if (this._listeners != null) {
            ActionListener[] listeners;
            for (ActionListener l : listeners = (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                l.actionPerformed(event);
            }
        }
    }

    protected void fireActionPerformed(Object source, int id, String actionCommand) {
        this.fireActionPerformed(new ActionEvent(source, id, actionCommand));
    }

    protected void fireEditingFinished(ActionEvent event) {
        this.fireActionPerformed(event.getSource(), event.getID(), EDITING_FINISHED);
    }

    protected void fireEditingFinished(Object source) {
        this.fireActionPerformed(source, 0, EDITING_FINISHED);
    }

    public abstract TComponent create();

    @Override
    public Component createComponent() {
        TComponent component = this.create();
        return component;
    }

    @Override
    public void setValue(Component component, Object value) {
        Component c = component;
        Object t = value;
        this.set(c, t);
    }

    protected abstract void set(TComponent var1, TType var2);

    protected abstract TType get(TComponent var1);

    protected abstract boolean empty(TComponent var1);

    protected void error(TComponent component, String error) {
        if (StringUtilities.isNullOrEmpty((String)error)) {
            if (this._defaultBackground != null) {
                this.setBackground(component, this._defaultBackground);
            }
        } else if (this.useErrorColor() && this._errorColor != null) {
            if (this._defaultBackground == null) {
                this._defaultBackground = this.getBackground(component);
            }
            this.setBackground(component, this.getErrorColor());
        }
    }

    protected void clear(TComponent component) {
        this.set(component, null);
    }

    @Override
    public Object getValue(Component component) {
        Component c = component;
        return this.get(c);
    }

    @Override
    public boolean isEmpty(Component component) {
        return this.empty(component);
    }

    @Override
    public void clearValue(Component component) {
        this.clear(component);
    }

    private ChangeSupport changeSupport() {
        if (this._changeSupport == null) {
            this._changeSupport = new ChangeSupport((Object)this);
        }
        return this._changeSupport;
    }

    @Override
    public void setError(Component component, String value) {
        this.error(component, value);
    }

    @Override
    public void setBackgroundColor(Component component, Color color) {
        this.setBackground(component, color);
    }

    protected void setBackground(TComponent component, Color color) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBackground(color);
        }
    }

    protected Color getBackground(TComponent component) {
        if (component instanceof JComponent) {
            return ((JComponent)component).getBackground();
        }
        return Color.white;
    }

    protected void handleError(Exception e) {
        NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)e.getMessage(), 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    @Override
    public Color getErrorColor() {
        return this._errorColor;
    }

    @Override
    public void setErrorColor(Color errorColor) {
        this._errorColor = errorColor;
    }

    @Override
    public boolean useErrorColor() {
        return this._useErrorColor;
    }

    @Override
    public void setUseErrorColor(boolean useErrorColor) {
        this._useErrorColor = useErrorColor;
    }
}

