/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.literal;

import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.literal.LiteralRegexExecNode;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.PreCalcResultVisitor;
import com.oracle.truffle.regex.tregex.string.Encodings;

public final class LiteralRegexEngine {
    public static LiteralRegexExecNode createNode(RegexLanguage language, RegexAST ast) {
        RegexProperties props = ast.getProperties();
        if (!(!ast.isLiteralString() || !props.isFixedCodePointWidth() || ast.getEncoding() != Encodings.UTF_16_RAW && props.hasLoneSurrogates() || props.hasQuantifiers() && ast.getRoot().getMinPath() > Short.MAX_VALUE)) {
            return LiteralRegexEngine.createLiteralNode(language, ast);
        }
        return null;
    }

    private static LiteralRegexExecNode createLiteralNode(RegexLanguage language, RegexAST ast) {
        PreCalcResultVisitor preCalcResultVisitor = PreCalcResultVisitor.run(ast, true);
        boolean caret = ast.getRoot().startsWithCaret();
        boolean dollar = ast.getRoot().endsWithDollar();
        if (ast.getRoot().getMinPath() == 0) {
            if (caret) {
                if (dollar) {
                    return new LiteralRegexExecNode.EmptyEquals(language, ast, preCalcResultVisitor);
                }
                return new LiteralRegexExecNode.EmptyStartsWith(language, ast, preCalcResultVisitor);
            }
            if (dollar) {
                return new LiteralRegexExecNode.EmptyEndsWith(language, ast, preCalcResultVisitor);
            }
            return new LiteralRegexExecNode.EmptyIndexOf(language, ast, preCalcResultVisitor);
        }
        if (caret) {
            if (dollar) {
                return new LiteralRegexExecNode.Equals(language, ast, preCalcResultVisitor);
            }
            return new LiteralRegexExecNode.StartsWith(language, ast, preCalcResultVisitor);
        }
        if (dollar) {
            return new LiteralRegexExecNode.EndsWith(language, ast, preCalcResultVisitor);
        }
        if (ast.getFlags().isSticky()) {
            return new LiteralRegexExecNode.RegionMatches(language, ast, preCalcResultVisitor);
        }
        if (preCalcResultVisitor.getLiteral().encodedLength() <= 64) {
            return new LiteralRegexExecNode.IndexOfString(language, ast, preCalcResultVisitor);
        }
        return null;
    }
}

