/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.paterva.maltego.collab.session.xmpp.bosh.BoshDebug;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshProxy;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URI;
import java.util.Arrays;
import org.jivesoftware.smack.proxy.ProxyInfo;

class BoshClientSocket
extends Socket {
    public BoshClientSocket(URI boshServer, String boshDomain, ProxyInfo proxyInfo, boolean isHttps) throws SocketException {
        super(new BoshSocketImpl(boshServer, boshDomain, proxyInfo, isHttps));
    }

    private static class BoshSocketImpl
    extends SocketImpl {
        private OutputStream _proxyOutput;
        private InputStream _clientInput;
        private OutputStream _clientOutput;
        private InputStream _proxyInput;
        private BoshProxy _proxy;
        private URI _serverUri;
        private String _serverDomain;
        private ProxyInfo _proxyInfo;
        private boolean _isHttps;

        BoshSocketImpl(URI boshServer, String boshDomain, ProxyInfo proxyInfo, boolean isHttps) {
            this._serverDomain = boshDomain;
            this._serverUri = boshServer;
            this._proxyInfo = proxyInfo;
            this._isHttps = isHttps;
        }

        @Override
        protected void create(boolean stream) throws IOException {
            PipedOutputStream proxyOutput = BoshDebug.DEBUG ? new DebugPipedOutputStream("PIPE TO Client") : new PipedOutputStream();
            PipedInputStream clientInput = new PipedInputStream(proxyOutput);
            PipedInputStream proxyInput = new PipedInputStream();
            PipedOutputStream clientOutput = BoshDebug.DEBUG ? new DebugPipedOutputStream("PIPE TO Server", proxyInput) : new PipedOutputStream(proxyInput);
            this._proxyOutput = proxyOutput;
            this._clientInput = clientInput;
            this._clientOutput = clientOutput;
            this._proxyInput = proxyInput;
            this._proxy = new BoshProxy(this._serverUri, this._serverDomain, this._proxyInput, this._proxyOutput, this._proxyInfo, this._isHttps);
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            this.connect(new InetSocketAddress(host, port), 0);
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            this.connect(new InetSocketAddress(address, port), 0);
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            this._proxy.start();
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
        }

        @Override
        protected void listen(int backlog) throws IOException {
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return this._clientInput;
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            return this._clientOutput;
        }

        @Override
        protected int available() throws IOException {
            return this.getInputStream().available();
        }

        @Override
        protected void close() throws IOException {
            if (this._proxy != null) {
                this._proxy.stop();
            }
            IOException ex = null;
            ex = this.closeStream(this._clientInput, ex);
            ex = this.closeStream(this._clientOutput, ex);
            ex = this.closeStream(this._proxyOutput, ex);
            if ((ex = this.closeStream(this._proxyInput, ex)) != null) {
                throw ex;
            }
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            return null;
        }

        private IOException closeStream(Closeable stream, IOException ex) {
            try {
                stream.close();
                return ex;
            }
            catch (IOException e) {
                if (ex == null) {
                    return e;
                }
                return ex;
            }
        }

        private class DebugPipedOutputStream
        extends PipedOutputStream {
            private final String name;

            public DebugPipedOutputStream(String name) {
                this.name = name;
            }

            public DebugPipedOutputStream(String name, PipedInputStream snk) throws IOException {
                super(snk);
                this.name = name;
            }

            @Override
            public void write(int b) throws IOException {
                System.out.println(BoshDebug.format(this.name + ": " + b));
                super.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                System.out.println(BoshDebug.format(this.name + ": " + new String(Arrays.copyOfRange(b, off, off + len))));
                super.write(b, off, len);
            }

            @Override
            public void write(byte[] b) throws IOException {
                System.out.println(BoshDebug.format(this.name + ": " + new String(b)));
                super.write(b);
            }
        }
    }
}

