/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.xmpp.MessageFillProvider;
import com.paterva.maltego.collab.session.xmpp.PayloadEncoder;
import com.paterva.maltego.collab.session.xmpp.Utils;
import com.paterva.maltego.collab.session.xmpp.XmppEncodedCollaborationExtension;
import com.paterva.maltego.util.NormalException;
import java.util.LinkedList;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.muc.MultiUserChat;

class XmppMucSendQueue {
    private MultiUserChat _muc;
    private MessageFillProvider _fillProvider;
    private PayloadEncoder _encoder;
    private Thread _sendThread;
    private final LinkedList<Packet> _queue = new LinkedList();
    private volatile boolean _stop;

    public XmppMucSendQueue(MultiUserChat muc, MessageFillProvider fillProvider, PayloadEncoder encoder) {
        this._muc = muc;
        this._fillProvider = fillProvider;
        this._encoder = encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this._stop = false;
        LinkedList<Packet> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.clear();
            this._sendThread = new Thread((Runnable)new Sender(), "XMPP packet sender");
            this._sendThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.checkStarted();
        this._stop = true;
        this._sendThread.interrupt();
        LinkedList<Packet> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String to, String xml) {
        this.checkStarted();
        LinkedList<Packet> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.add(new Packet(to, xml));
            this._queue.notifyAll();
        }
    }

    private void checkStarted() throws IllegalStateException {
        if (this._sendThread == null || !this._sendThread.isAlive() || this._stop) {
            throw new IllegalStateException("XMPP packet sender not started");
        }
    }

    private XmppEncodedCollaborationExtension createExtension(String payload) throws CollaborationException {
        return new XmppEncodedCollaborationExtension(Utils.createEncodedContent(this._encoder, payload));
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!XmppMucSendQueue.this._stop) {
                Packet p = null;
                LinkedList linkedList = XmppMucSendQueue.this._queue;
                synchronized (linkedList) {
                    if (!XmppMucSendQueue.this._queue.isEmpty()) {
                        p = (Packet)XmppMucSendQueue.this._queue.remove();
                    } else {
                        try {
                            XmppMucSendQueue.this._queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (p == null) continue;
                this.send(p);
            }
        }

        private void send(Packet p) {
            try {
                Message msg = XmppMucSendQueue.this._muc.createMessage();
                if (p.getTo() != null) {
                    msg.setTo(p.getTo());
                    msg.setType(Message.Type.chat);
                }
                msg.setBody(XmppMucSendQueue.this._fillProvider.getNextFillMessage());
                msg.addExtension((PacketExtension)XmppMucSendQueue.this.createExtension(p.getXml()));
                XmppMucSendQueue.this._muc.sendMessage(msg);
            }
            catch (CollaborationException ex) {
                NormalException.logStackTrace((Throwable)((Object)ex));
            }
            catch (XMPPException ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
        }
    }

    private static class Packet {
        private String _to;
        private String _xml;

        public Packet(String to, String xml) {
            this._to = to;
            this._xml = xml;
        }

        public String getTo() {
            return this._to;
        }

        public String getXml() {
            return this._xml;
        }
    }
}

