/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab;

import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.Payload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class PayloadCollection
implements Iterable<Payload> {
    public static PayloadCollection EMPTY = new Empty();
    private static Iterator<Payload> EMPTY_ITERATOR = new EmptyIterator();

    protected PayloadCollection() {
    }

    public boolean hasType(String type) {
        for (Payload payload : this) {
            if (!payload.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public Collection<Payload> ofType(String type) {
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        for (Payload payload : this) {
            if (!payload.getType().equals(type)) continue;
            payloads.add(payload);
        }
        return payloads;
    }

    public Collection<Payload> ofType(String type, boolean mine) {
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        for (Payload payload : this) {
            if (!payload.getType().equals(type) || payload.getFrom().isMe() != mine) continue;
            payloads.add(payload);
        }
        return payloads;
    }

    public PayloadCollection payloadOfType(String type) {
        List payloads = new List();
        for (Payload payload : this) {
            if (!payload.getType().equals(type)) continue;
            payloads.add(payload);
        }
        return payloads;
    }

    public PayloadCollection payloadOfType(String type, boolean mine) {
        List payloads = new List();
        for (Payload payload : this) {
            if (!payload.getType().equals(type) || payload.getFrom().isMe() != mine) continue;
            payloads.add(payload);
        }
        return payloads;
    }

    public Payload first(String type) {
        for (Payload payload : this) {
            if (!payload.getType().equals(type)) continue;
            return payload;
        }
        return null;
    }

    public Payload first(String type, boolean mine) {
        for (Payload payload : this) {
            if (!payload.getType().equals(type) || payload.getFrom().isMe() != mine) continue;
            return payload;
        }
        return null;
    }

    public String typeString() {
        HashSet<String> types = new HashSet<String>();
        for (Payload p : this) {
            types.add(p.getType());
        }
        StringBuilder buffer = new StringBuilder();
        for (String s : types) {
            buffer.append(" ");
            buffer.append(s);
        }
        if (buffer.length() > 0) {
            return buffer.substring(1, buffer.length() - 1);
        }
        return buffer.toString();
    }

    public PayloadCollection historic() {
        return this.historic(true);
    }

    public PayloadCollection live() {
        return this.historic(false);
    }

    public abstract int size();

    public abstract Payload last();

    protected PayloadCollection historic(boolean value) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (this.size() == 1) {
            Payload p = (Payload)this.iterator().next();
            if (p.isHistoric() == value) {
                return new Singleton(p);
            }
            return EMPTY;
        }
        List list = new List();
        for (Payload p : this) {
            if (p.isHistoric() != value) continue;
            list.add(p);
        }
        if (list.isEmpty()) {
            return EMPTY;
        }
        return list;
    }

    public abstract boolean isEmpty();

    public static PayloadCollection create(String id, Participant from, Map<String, String> bodies, Date date) {
        if (bodies.isEmpty()) {
            return EMPTY;
        }
        if (bodies.size() == 1) {
            Map.Entry<String, String> entry = bodies.entrySet().iterator().next();
            return PayloadCollection.create(new Payload(id, from, entry.getKey(), entry.getValue(), date));
        }
        List list = new List();
        for (Map.Entry<String, String> entry : bodies.entrySet()) {
            list.add(new Payload(id, from, entry.getKey(), entry.getValue(), date));
        }
        return list;
    }

    public static PayloadCollection create(PayloadCollection ... payloads) {
        return new Composite(payloads);
    }

    public static PayloadCollection create(Payload payload) {
        return new Singleton(payload);
    }

    public static PayloadCollection getEmpty() {
        return EMPTY;
    }

    private static class SingleIterator
    implements Iterator<Payload> {
        private Payload _payload;

        public SingleIterator(Payload payload) {
            this._payload = payload;
        }

        @Override
        public boolean hasNext() {
            return this._payload != null;
        }

        @Override
        public Payload next() {
            Payload p = this._payload;
            this._payload = null;
            return p;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class EmptyIterator
    implements Iterator<Payload> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Payload next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class CompoundPayloadIterator
    implements Iterator<Payload> {
        private PayloadCollection[] _payloads;
        private int _index = 0;
        private Iterator<Payload> _current;

        public CompoundPayloadIterator(PayloadCollection[] payloads) {
            this._payloads = payloads;
            this._current = this.nextIterator();
        }

        @Override
        public boolean hasNext() {
            Iterator<Payload> it = this.currentIterator();
            if (it == null) {
                return false;
            }
            return it.hasNext();
        }

        private Iterator<Payload> currentIterator() {
            while (this._current != null && !this._current.hasNext()) {
                this._current = this.nextIterator();
            }
            return this._current;
        }

        private Iterator<Payload> nextIterator() {
            if (this._index < this._payloads.length) {
                PayloadCollection p = this._payloads[this._index];
                ++this._index;
                return p.iterator();
            }
            return null;
        }

        @Override
        public Payload next() {
            Iterator<Payload> it = this.currentIterator();
            if (it == null) {
                return null;
            }
            return it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class Composite
    extends PayloadCollection {
        private PayloadCollection[] _payloads;

        public Composite(PayloadCollection[] payloads) {
            this._payloads = payloads;
        }

        @Override
        public boolean isEmpty() {
            return this._payloads.length == 0;
        }

        @Override
        public Iterator<Payload> iterator() {
            return new CompoundPayloadIterator(this._payloads);
        }

        @Override
        public int size() {
            int count = 0;
            for (PayloadCollection c : this._payloads) {
                count += c.size();
            }
            return count;
        }

        @Override
        public Payload last() {
            return this._payloads[this._payloads.length - 1].last();
        }
    }

    private static class Singleton
    extends PayloadCollection {
        private final Payload _payload;

        public Singleton(Payload payload) {
            this._payload = payload;
        }

        @Override
        public boolean hasType(String type) {
            return this._payload.isType(type);
        }

        @Override
        public PayloadCollection payloadOfType(String type) {
            if (this._payload.isType(type)) {
                return this;
            }
            return EMPTY;
        }

        @Override
        public PayloadCollection payloadOfType(String type, boolean mine) {
            if (this._payload.isType(type) && this._payload.getFrom().isMe() == mine) {
                return this;
            }
            return EMPTY;
        }

        @Override
        public Collection<Payload> ofType(String type) {
            if (this._payload.isType(type)) {
                return Collections.singleton(this._payload);
            }
            return Collections.emptySet();
        }

        @Override
        public Collection<Payload> ofType(String type, boolean mine) {
            if (this._payload.isType(type) && this._payload.getFrom().isMe() == mine) {
                return Collections.singleton(this._payload);
            }
            return Collections.emptySet();
        }

        @Override
        public Payload first(String type) {
            if (this._payload.isType(type)) {
                return this._payload;
            }
            return null;
        }

        @Override
        public Payload first(String type, boolean mine) {
            if (this._payload.isType(type) && this._payload.getFrom().isMe() == mine) {
                return this._payload;
            }
            return null;
        }

        @Override
        public String typeString() {
            return this._payload.getType();
        }

        @Override
        public boolean isEmpty() {
            return this._payload == null;
        }

        @Override
        protected PayloadCollection historic(boolean value) {
            if (this._payload.isHistoric() == value) {
                return this;
            }
            return EMPTY;
        }

        @Override
        public Iterator<Payload> iterator() {
            return new SingleIterator(this._payload);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Payload last() {
            return this._payload;
        }
    }

    public static class List
    extends PayloadCollection {
        private ArrayList<Payload> _payloads = new ArrayList();

        public void add(Payload payload) {
            this._payloads.add(payload);
        }

        public void addAll(PayloadCollection payloads) {
            for (Payload p : payloads) {
                this.add(p);
            }
        }

        @Override
        public boolean isEmpty() {
            return this._payloads.isEmpty();
        }

        @Override
        public Iterator<Payload> iterator() {
            return this._payloads.iterator();
        }

        @Override
        public int size() {
            return this._payloads.size();
        }

        @Override
        public Payload last() {
            if (this.isEmpty()) {
                return null;
            }
            return this._payloads.get(this._payloads.size() - 1);
        }
    }

    private static class Empty
    extends PayloadCollection {
        private Empty() {
        }

        @Override
        public boolean hasType(String type) {
            return false;
        }

        @Override
        public Collection<Payload> ofType(String type) {
            return Collections.emptySet();
        }

        @Override
        public Collection<Payload> ofType(String type, boolean mine) {
            return Collections.emptySet();
        }

        @Override
        public PayloadCollection payloadOfType(String type) {
            return this;
        }

        @Override
        public PayloadCollection payloadOfType(String type, boolean mine) {
            return this;
        }

        @Override
        public Payload first(String type) {
            return null;
        }

        @Override
        public Payload first(String type, boolean mine) {
            return null;
        }

        @Override
        public String typeString() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        protected PayloadCollection historic(boolean value) {
            return EMPTY;
        }

        @Override
        public Iterator<Payload> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Payload last() {
            return null;
        }
    }
}

