/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.util.BytesRef;

class SortHelper {
    SortHelper() {
    }

    public static SortField createLongSortField(String field, boolean reverse, boolean emptyFirst) {
        SortedNumericSortField sortField = new SortedNumericSortField(field, SortField.Type.LONG, reverse, reverse ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN);
        if (reverse ^ emptyFirst) {
            sortField.setMissingValue((Object)Long.MIN_VALUE);
        } else {
            sortField.setMissingValue((Object)Long.MAX_VALUE);
        }
        return sortField;
    }

    public static IndexableField createLongDocValueField(String field, long value) {
        return new SortedNumericDocValuesField(field, value);
    }

    public static SortField createStringSortField(String field, boolean reverse, boolean emptyFirst) {
        SortedSetSortField sortField = new SortedSetSortField(field, reverse, reverse ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
        if (reverse ^ emptyFirst) {
            sortField.setMissingValue(SortField.STRING_FIRST);
        } else {
            sortField.setMissingValue(SortField.STRING_LAST);
        }
        return sortField;
    }

    public static IndexableField createStringDocValueField(String field, String value) {
        return new SortedSetDocValuesField(field, new BytesRef((CharSequence)value));
    }
}

