/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraProperty;
import com.pinkmatter.pandora.lucene.LuceneSchema;
import com.pinkmatter.pandora.lucene.PandoraQueryImpl;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;

class PropertyFieldVisitor
extends DocumentStoredFieldVisitor {
    private boolean _inclusionList = true;
    private final Set<String> _fields = new HashSet<String>();

    public PropertyFieldVisitor(LuceneSchema schema, PandoraQueryImpl.IncludeProperty[] includeProperties) throws PandoraException {
        boolean bl = this._inclusionList = includeProperties != null && includeProperties.length > 0 && includeProperties[0].isIncluded();
        if (includeProperties != null) {
            for (PandoraQueryImpl.IncludeProperty property : includeProperties) {
                List<PandoraProperty> pandoraProps = schema.getProperties(property.getProperty(), property.getType());
                for (PandoraProperty pandoraProp : pandoraProps) {
                    Set<String> propFields = schema.getFieldHelper().getFields(property.getProperty(), pandoraProp.getType());
                    if (this._inclusionList == property.isIncluded()) {
                        this._fields.addAll(propFields);
                        continue;
                    }
                    this._fields.removeAll(propFields);
                }
            }
        }
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fi) throws IOException {
        if (this._inclusionList == this._fields.contains(fi.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }
}

