/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2;

import com.paterva.maltego.transform.protocol.v2api.LocalTransformExecutor;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.openide.windows.InputOutput;

public class IOWindowLocalTransformExecutor
extends LocalTransformExecutor {
    public String execute(String command, File workingDir, Collection<String> params, boolean debug) throws TransformRunException, InterruptedException, ExecutionException, IOException {
        String message = null;
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder(command);
        processBuilder = processBuilder.workingDirectory(workingDir);
        for (String param : params) {
            processBuilder = processBuilder.addArgument(param);
        }
        try (MessageInputProcessor processor = new MessageInputProcessor();){
            ExecutionDescriptor ed = new ExecutionDescriptor().charset(Charset.forName("UTF-8")).frontWindow(debug).controllable(debug);
            ed = ed.outProcessorFactory(ip -> InputProcessors.proxy((InputProcessor[])new InputProcessor[]{ip, processor}));
            if (!debug) {
                ed = ed.inputOutput(InputOutput.NULL);
            }
            ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)ed, (String)("Debug " + command));
            Future task = null;
            try {
                task = service.run();
                int returnCode = (Integer)task.get();
                if (returnCode != 0) {
                    throw new TransformRunException("Local transform \"" + command + "\" returned with exit code " + returnCode);
                }
                message = processor.getMessage();
            }
            catch (InterruptedException ex) {
                if (task != null) {
                    task.cancel(true);
                }
                throw ex;
            }
            catch (Exception ex) {
                throw new TransformRunException("Error running local transform: " + ex.getMessage());
            }
        }
        return message;
    }

    private static class MessageInputProcessor
    implements InputProcessor {
        private StringBuffer _buffer = new StringBuffer();

        private MessageInputProcessor() {
        }

        public void processInput(char[] chars) throws IOException {
            this._buffer.append(chars);
        }

        public void reset() throws IOException {
        }

        public void close() throws IOException {
        }

        public String getMessage() {
            return this._buffer.toString();
        }
    }
}

