/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.IdentityProvider;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import com.paterva.maltego.ui.graph.transacting.GraphTransactor;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.ui.graph.transactions.TransactionBatchFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.awt.StatusDisplayer;
import yguard.A.J.SA;

public class ReverseLinksAction
extends TopGraphSelectionContextAction {
    @Override
    protected boolean isEnabled(SA viewGraph) {
        GraphID graphID = viewGraph == null ? null : GraphIDProvider.forGraph((SA)viewGraph);
        return graphID != null && !this.getSelectedLinks(graphID).isEmpty();
    }

    public String getName() {
        return "Reverse Links";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/ReverseLinks.png";
    }

    @Override
    protected void actionPerformed(GraphView graphView) {
        GraphSelection selection;
        Set selectedModelLinks;
        GraphID graphID = this.getTopGraphID();
        List<MaltegoLink> links = this.getManualLinks(GraphStoreHelper.getMaltegoLinks((GraphID)graphID, (Collection)(selectedModelLinks = (selection = GraphSelection.forGraph((GraphID)graphID)).getSelectedModelLinks())));
        if (links.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText("No manual links selected. (Only manually created links can be reversed)");
            return;
        }
        GraphTransactionBatch batch = TransactionBatchFactory.createReverseLinksBatch(graphID, selectedModelLinks);
        Set<MaltegoLink> newSelection = this.getNewSelection(batch);
        selectedModelLinks = newSelection.stream().map(IdentityProvider::getID).collect(Collectors.toSet());
        Collection<LinkUpdate> linkUpdates = ModifiedHelper.createLinkUpdates(GraphUser.getUser(graphID), newSelection);
        if (!linkUpdates.isEmpty()) {
            batch.add(GraphTransactions.updateEntitiesAndLinks(Collections.emptySet(), linkUpdates));
        }
        GraphTransactor transactor = GraphTransactorRegistry.getDefault().get(graphID);
        transactor.doTransactions(batch);
        selection.setSelectedModelLinks(selectedModelLinks);
    }

    private List<MaltegoLink> getManualLinks(Collection<MaltegoLink> links) {
        ArrayList<MaltegoLink> manualLinks = new ArrayList<MaltegoLink>();
        for (MaltegoLink link : links) {
            if (!"maltego.link.manual-link".equals(link.getTypeName())) continue;
            manualLinks.add(link);
        }
        return manualLinks;
    }

    private Set<MaltegoLink> getSelectedLinks(GraphID graphID) {
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        Set selectedModelLinks = selection.getSelectedModelLinks();
        return GraphStoreHelper.getMaltegoLinks((GraphID)graphID, (Collection)selectedModelLinks);
    }

    private Set<MaltegoLink> getNewSelection(GraphTransactionBatch batch) {
        return batch.getTransactions().stream().filter(transaction -> transaction.getOperation() == GraphOperation.Add).flatMap(transaction -> this.getLinks((GraphTransaction)transaction).stream()).collect(Collectors.toSet());
    }

    private List<MaltegoLink> getLinks(GraphTransaction transaction) {
        return transaction.getLinkIDs().stream().map(linkID -> transaction.getLink((LinkID)linkID)).collect(Collectors.toList());
    }
}

