/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.WindowUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.J.SA;

public abstract class AllNotesAction
extends TopGraphAction {
    protected abstract boolean isShowNotes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(TopComponent tc) {
        try {
            Set allEntities;
            List<MaltegoEntity> entitiesWithNotes;
            WindowUtil.showWaitCursor();
            SA graph = this.getTopViewGraph();
            GraphID graphID = this.getTopGraphID();
            GraphStoreRegistry registry = GraphStoreRegistry.getDefault();
            if (graph != null && registry.isExistingAndOpen(graphID) && (entitiesWithNotes = (allEntities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID)).stream().filter(Objects::nonNull).filter(entity -> !StringUtilities.isNullOrEmpty((String)entity.getNotes())).collect(Collectors.toList())).size() > 0) {
                GraphTransactionHelper.doChangeNotes((D)graph, entitiesWithNotes, this.isShowNotes());
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }
}

