/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui;

import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.paterva.maltego.licensing.C;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseDateFormat;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedStatistics;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.HubSeedsHomePanel;
import com.paterva.maltego.seeds.ui.hub.HubSeedManager;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.finder.SeedDiscoveryManager;
import com.paterva.maltego.transform.finder.UpdateInstalledSeedsAction;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.ui.GotoUrlAction;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.openide.util.ImageUtilities;

public class HubTitlePanel
extends JPanel {
    private final TitleComponent component;
    private final Color bg = MaltegoLAF.getLookAndFeelDefaults().getColor("hub-title-bg");
    private ChangeListener licenseListener;

    public HubTitlePanel(HubSeedManager manager) {
        this.initComponents();
        this.setBorder(new EmptyBorder(3, HubSeedsHomePanel.HUB_PADDING_SIDES, 3, HubSeedsHomePanel.HUB_PADDING_SIDES));
        this.component = new TitleComponent(manager, this.bg);
        this.add(this.component);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.licenseListener = ignored -> this.updateLicenseInfo();
        LicenseManager.A().A(this.licenseListener);
        this.updateLicenseInfo();
    }

    @Override
    public void removeNotify() {
        LicenseManager.A().B(this.licenseListener);
        this.licenseListener = null;
        super.removeNotify();
    }

    private void updateLicenseInfo() {
        this.setBackground(this.bg);
        this.component.updateLicenseLabel();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private static class TitleComponent
    extends JComponent {
        private final JLabel _titleLabel;
        private final RefreshAction _refreshAction;
        private final Color _titleFg = MaltegoLAF.getLookAndFeelDefaults().getColor("hub-title-fg");
        private final Color _offlineFg = MaltegoLAF.getLookAndFeelDefaults().getColor("hub-title-offline-fg");
        private final Color _buttonFg = DarculaButtonUI.getButtonColorHubTitle();
        private final JLabel _licenseLabel = new JLabel();
        private final JLabel _offlineLabel;
        private final JLabel _hubCountsLabel = new JLabel();
        private boolean _busyUpdatingLicenseLabel = false;
        private boolean _busyUpdatingOfflineLabel = false;
        private boolean _busyUpdatingHubCountsLabel = false;
        private PropertyChangeListener _hubSeedRegistryListener;
        private PropertyChangeListener _seedDiscoveryManagerListener;

        public TitleComponent(HubSeedManager manager, Color bg) {
            this.setLayout(new GridBagLayout());
            this._titleLabel = new JLabel("Maltego Data Hub");
            this._titleLabel.setForeground(this._titleFg);
            Font font = this._titleLabel.getFont();
            this._titleLabel.setFont(font.deriveFont(1, font.getSize2D() + 2.0f));
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)this._titleLabel, gbc);
            this.updateLicenseLabel();
            this._licenseLabel.setForeground(this._titleFg);
            this._licenseLabel.setHorizontalTextPosition(0);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)this._licenseLabel, gbc);
            this._offlineLabel = new JLabel("(OFFLINE)");
            this._offlineLabel.setHorizontalAlignment(0);
            this._offlineLabel.setForeground(this._offlineFg);
            this._offlineLabel.setToolTipText("The Maltego Data Hub is currently offline. Only cached and user items are displayed.");
            gbc = new GridBagConstraints(1, 0, 1, 2, 0.9, 0.0, 10, 1, new Insets(0, 0, 0, 0), 40, 0);
            this.add((Component)this._offlineLabel, gbc);
            int size = 22;
            JPanel filler1 = this.getFillerPanel(size);
            gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)filler1, gbc);
            JPanel filler2 = this.getFillerPanel(size);
            gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)filler2, gbc);
            JPanel rightPanel = new JPanel();
            rightPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            rightPanel.setBackground(bg);
            rightPanel.setOpaque(false);
            rightPanel.setLayout(new GridBagLayout());
            JPanel filler3 = this.getFillerPanel(size);
            gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0);
            rightPanel.add((Component)filler3, gbc);
            JPanel filler4 = this.getFillerPanel(size);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0);
            rightPanel.add((Component)filler4, gbc);
            this._refreshAction = new RefreshAction(manager);
            JButton refreshButton = new JButton(this._refreshAction);
            refreshButton.setForeground(this._buttonFg);
            refreshButton.putClientProperty("inHubTitlePanel", Boolean.TRUE);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 10), 0, 0);
            rightPanel.add((Component)refreshButton, gbc);
            this.updateHubCountsLabel();
            gbc = new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            this._hubCountsLabel.setHorizontalTextPosition(2);
            this._hubCountsLabel.setHorizontalAlignment(2);
            rightPanel.add((Component)this._hubCountsLabel, gbc);
            JButton updateButton = new JButton((Action)new UpdateInstalledSeedsAction());
            updateButton.setForeground(this._buttonFg);
            updateButton.putClientProperty("inHubTitlePanel", Boolean.TRUE);
            gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0);
            rightPanel.add((Component)updateButton, gbc);
            JPanel filler5 = this.getFillerPanel(size);
            gbc = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0);
            rightPanel.add((Component)filler5, gbc);
            JButton helpButton = new JButton(new HelpAction());
            helpButton.putClientProperty("inHubTitlePanel", Boolean.TRUE);
            helpButton.setPreferredSize(new Dimension(size, size));
            gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0);
            rightPanel.add((Component)helpButton, gbc);
            gbc = new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)rightPanel, gbc);
            this.updateOfflineLabel();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this._hubSeedRegistryListener = new HubSeedRegistryListener();
            HubSeedRegistry.getDefault().addPropertyChangeListener(this._hubSeedRegistryListener);
            this._seedDiscoveryManagerListener = new SeedDiscoveryManagerListener();
            SeedDiscoveryManager.getDefault().addPropertyChangeListener(this._seedDiscoveryManagerListener);
            this.updateLicenseLabel();
            this.updateOfflineLabel();
            this.updateHubCountsLabel();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            HubSeedRegistry.getDefault().removePropertyChangeListener(this._hubSeedRegistryListener);
            this._hubSeedRegistryListener = null;
            SeedDiscoveryManager.getDefault().removePropertyChangeListener(this._seedDiscoveryManagerListener);
            this._seedDiscoveryManagerListener = null;
        }

        public void updateLicenseLabel() {
            if (!this._busyUpdatingLicenseLabel) {
                this._busyUpdatingLicenseLabel = true;
                String licenseLabelText = System.getProperty("maltego.product-name", "Maltego");
                A licenseMode = LicenseManager.A().A(false);
                C validity = licenseMode.J();
                if (licenseMode.W()) {
                    validity = licenseMode.R();
                }
                if (validity != null) {
                    E capability = validity.J();
                    licenseLabelText = licenseLabelText + " - License active until " + LicenseDateFormat.format((long)capability.G());
                } else {
                    licenseLabelText = licenseLabelText + " - Not licensed";
                }
                this._licenseLabel.setText(licenseLabelText);
                this._busyUpdatingLicenseLabel = false;
            }
        }

        private void updateOfflineLabel() {
            if (!this._busyUpdatingOfflineLabel) {
                boolean maltegoIdOffline;
                this._busyUpdatingOfflineLabel = true;
                A licenseMode = LicenseManager.A().A(false);
                boolean bl = maltegoIdOffline = licenseMode.U() && licenseMode.S();
                if (maltegoIdOffline) {
                    this._offlineLabel.setText("(Maltego ID: " + (licenseMode.S() ? "Offline" : "Online") + " Activated)");
                } else {
                    this._offlineLabel.setText("(OFFLINE)");
                }
                boolean online = HubSeedRegistry.getDefault().isOnline();
                this._offlineLabel.setVisible(maltegoIdOffline || !online);
                this._busyUpdatingOfflineLabel = false;
            }
        }

        private void updateHubCountsLabel() {
            if (!this._busyUpdatingHubCountsLabel) {
                this._busyUpdatingHubCountsLabel = true;
                HubSeedRegistry hubSeedRegistry = HubSeedRegistry.getDefault();
                List seeds = hubSeedRegistry.getSeeds(false).getSeeds();
                int hubItemsCount = seeds.size();
                String combined = hubItemsCount + " Hub items total";
                int installedHubItemsCount = 0;
                int installedTxCount = 0;
                HubSeedSettings settings = HubSeedSettings.getDefault();
                boolean needFullTxCount = false;
                for (HubSeedDescriptor seed : seeds) {
                    if (!settings.isInstalled(seed)) continue;
                    ++installedHubItemsCount;
                    HubSeedStatistics stats = seed.getStatistics();
                    if (stats == null) {
                        needFullTxCount = true;
                        continue;
                    }
                    if (needFullTxCount) continue;
                    Integer txCount = stats.getTransformCount();
                    if (txCount == null) {
                        needFullTxCount = true;
                        continue;
                    }
                    installedTxCount += txCount.intValue();
                }
                if (needFullTxCount) {
                    installedTxCount = this.getInstalledTxCount(new String[]{"Remote"});
                }
                combined = combined + "  |  " + installedHubItemsCount + " Hub items installed (" + installedTxCount + " Transforms)";
                this._hubCountsLabel.setText(combined);
                boolean online = hubSeedRegistry.isOnline();
                this._hubCountsLabel.setForeground(online ? this._titleFg : this._offlineFg);
                this._busyUpdatingHubCountsLabel = false;
            }
        }

        private int getInstalledTxCount(String[] repos) {
            TransformRepositoryRegistry txRepoRegistry = TransformRepositoryRegistry.getDefault();
            TransformServerRegistry serverRegistry = TransformServerRegistry.getDefault();
            ArrayList<TransformDefinition> installedTxs = new ArrayList<TransformDefinition>();
            for (String repo : repos) {
                TransformRepository repository = txRepoRegistry.getRepository(repo);
                if (repository == null) continue;
                for (TransformDefinition def : repository.getAll()) {
                    if (!serverRegistry.exists(def.getName(), false)) continue;
                    installedTxs.add(def);
                }
            }
            return installedTxs.size();
        }

        private JPanel getFillerPanel(int height) {
            JPanel filler = new JPanel();
            filler.setOpaque(false);
            filler.setPreferredSize(new Dimension(3, height));
            return filler;
        }

        private static class HelpAction
        extends AbstractAction {
            private static final ImageIcon IMG_HELP = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/seeds/ui/resources/Info.png", (boolean)true);

            public HelpAction() {
                super("", IMG_HELP);
                this.putValue("ShortDescription", "Visit the Maltego Data Hub help website");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GotoUrlAction delegate = new GotoUrlAction(MaltegoUrl.getCurrent().getGotoTransformHubInfo());
                delegate.actionPerformed(e);
            }
        }

        private class SeedDiscoveryManagerListener
        implements PropertyChangeListener {
            private SeedDiscoveryManagerListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (("installingHubSeed".equals(evt.getPropertyName()) || "uninstallingHubSeed".equals(evt.getPropertyName()) || "updating".equals(evt.getPropertyName())) && (evt.getNewValue() == null || Boolean.FALSE.equals(evt.getNewValue()))) {
                    TitleComponent.this.updateHubCountsLabel();
                }
            }
        }

        private class HubSeedRegistryListener
        implements PropertyChangeListener {
            private HubSeedRegistryListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("onlineChanged".equals(evt.getPropertyName())) {
                    TitleComponent.this.updateOfflineLabel();
                } else if ("seedsChanged".equals(evt.getPropertyName())) {
                    TitleComponent.this.updateHubCountsLabel();
                }
            }
        }

        private static class RefreshAction
        extends AbstractAction {
            private final HubSeedManager _manager;

            public RefreshAction(HubSeedManager manager) {
                super("[REFRESH]");
                this._manager = manager;
                this.putValue("ShortDescription", "Refresh the Maltego Data Hub");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this._manager.refresh(true);
            }
        }
    }
}

