/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.remote;

import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.protocol.api.DiscoveryInfo;
import com.paterva.maltego.transform.protocol.api.ProxyException;
import com.paterva.maltego.transform.protocol.api.TransformFindException;
import com.paterva.maltego.transform.protocol.api.TransformListInfo;
import com.paterva.maltego.transform.protocol.v2api.messaging.DiscoveryResponse;
import com.paterva.maltego.transform.protocol.v2api.messaging.ExceptionResponse;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyFactory;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListResponse;
import com.paterva.maltego.transform.protocol.v2api.remote.AuthenticatorTranslator;
import com.paterva.maltego.transform.protocol.v2api.remote.DiscoveryInfoTranslator;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformFindException;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformSource;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformTranslator;
import org.openide.util.Exceptions;

public class V2RemoteTransformSource
extends RemoteTransformSource {
    @Override
    public DiscoveryInfo getDiscoveryInfo(String seedUrl, String sourceDescription, boolean httpsOnly, int timeout, ProtocolVersion version) throws TransformFindException, CertificateNeedValidationException {
        try {
            DiscoveryResponse response;
            Proxy p = this.getProxy(sourceDescription);
            DiscoveryInfoTranslator tt = new DiscoveryInfoTranslator(seedUrl);
            MaltegoMessageWrapper wrapper = p.listTransforms(httpsOnly, timeout, false);
            DiscoveryResponse discoveryResponse = response = wrapper == null ? null : wrapper.getDiscoveryResponse();
            if (response == null) {
                ExceptionResponse exception;
                ExceptionResponse exceptionResponse = exception = wrapper == null ? null : wrapper.getExceptionResponse();
                if (exception == null) {
                    throw new RemoteTransformFindException("NULL response received");
                }
                throw new RemoteTransformFindException(exception);
            }
            this.replaceMacros(response, sourceDescription);
            try {
                return tt.translate(response);
            }
            catch (Exception ex) {
                throw new TransformFindException("Invalid message format: " + ex.getMessage(), ex);
            }
        }
        catch (ProxyException ex) {
            throw new TransformFindException("Error during remote execution: " + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public TransformListInfo getTransforms(String sourceDescription, int timeout) throws TransformFindException, CertificateNeedValidationException {
        try {
            Proxy p = this.getProxy(sourceDescription);
            MaltegoMessageWrapper wrapper = p.listTransforms(true, timeout, true);
            TransformListResponse response = wrapper.getListResponse();
            if (response == null) {
                ExceptionResponse exception = wrapper.getExceptionResponse();
                if (exception == null) {
                    throw new RemoteTransformFindException("NULL response received");
                }
                throw new RemoteTransformFindException(exception);
            }
            try {
                TransformListInfo info = new TransformListInfo();
                AuthenticatorTranslator at = new AuthenticatorTranslator();
                info.getOAuthAuthenticators().addAll(at.translateOAuth(response.getAuthenticators()));
                RemoteTransformTranslator tt = new RemoteTransformTranslator();
                info.getTransforms().addAll(tt.translate(response.getTransforms()));
                return info;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                throw new TransformFindException("Invalid message format", ex);
            }
        }
        catch (ProxyException ex) {
            throw new TransformFindException("Error during remote execution", (Exception)((Object)ex));
        }
    }

    Proxy getProxy(String source) {
        return ProxyFactory.getDefault().createProxy(source);
    }
}

