/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.IoProvider;

final class IoSSLProcessor {
    private static final Logger LOG = Logger.getLogger(IoSSLProcessor.class.getName());
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final SSLEngine sslEngine;
    private final boolean isClientMode;
    private final AbstractMemoryManager memoryManager;
    private final EventHandler eventHandler;
    private int minNetBufferSize;
    private int minEncryptedBufferSize;
    private ByteBuffer unprocessedInNetData = ByteBuffer.allocate(0);
    private final Object unprocessedInNetDataGuard = new Object();
    private final LinkedList<ByteBuffer> outAppDataList = new LinkedList();

    IoSSLProcessor(SSLContext sslContext, boolean isClientMode, AbstractMemoryManager memoryManager, EventHandler eventHandler) {
        this.isClientMode = isClientMode;
        this.memoryManager = memoryManager;
        this.eventHandler = eventHandler;
        this.sslEngine = sslContext.createSSLEngine();
        if (isClientMode) {
            if (IoProvider.getSSLEngineClientEnabledCipherSuites() != null) {
                this.sslEngine.setEnabledCipherSuites(IoProvider.getSSLEngineClientEnabledCipherSuites());
            }
            if (IoProvider.getSSLEngineClientEnabledProtocols() != null) {
                this.sslEngine.setEnabledProtocols(IoProvider.getSSLEngineClientEnabledProtocols());
            }
        } else {
            if (IoProvider.getSSLEngineServerEnabledCipherSuites() != null) {
                this.sslEngine.setEnabledCipherSuites(IoProvider.getSSLEngineServerEnabledCipherSuites());
            }
            if (IoProvider.getSSLEngineServerEnabledProtocols() != null) {
                this.sslEngine.setEnabledProtocols(IoProvider.getSSLEngineServerEnabledProtocols());
            }
            if (IoProvider.getSSLEngineServerWantClientAuth() != null) {
                this.sslEngine.setWantClientAuth(IoProvider.getSSLEngineServerWantClientAuth());
            }
            if (IoProvider.getSSLEngineServerNeedClientAuth() != null) {
                this.sslEngine.setNeedClientAuth(IoProvider.getSSLEngineServerNeedClientAuth());
            }
        }
        this.minEncryptedBufferSize = this.sslEngine.getSession().getApplicationBufferSize();
        this.minNetBufferSize = this.sslEngine.getSession().getPacketBufferSize();
        if (LOG.isLoggable(Level.FINE)) {
            if (isClientMode) {
                LOG.fine("initializing ssl processor (client mode)");
            } else {
                LOG.fine("initializing ssl processor (server mode)");
            }
            LOG.fine("app buffer size is " + this.minEncryptedBufferSize);
            LOG.fine("packet buffer size is " + this.minNetBufferSize);
        }
        this.sslEngine.setUseClientMode(isClientMode);
    }

    void start() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            if (this.isClientMode) {
                LOG.fine("calling sslEngine beginHandshake and calling encncrypt to initiate handeshake (client mode)");
            } else {
                LOG.fine("calling sslEngine beginHandshake (server mode)");
            }
        }
        try {
            this.sslEngine.beginHandshake();
        }
        catch (SSLException sslEx) {
            throw new RuntimeException(sslEx);
        }
        if (this.isClientMode) {
            this.encrypt();
        }
    }

    void destroy() {
        block2: {
            this.sslEngine.closeOutbound();
            try {
                this.eventHandler.onSSLProcessorClosed();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by calling ssl processor closed caal back on " + this.eventHandler + " reason: " + DataConverter.toString(ioe));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrypt(ByteBuffer[] encryptedBufferList) throws IOException, ClosedChannelException {
        try {
            for (int i = 0; i < encryptedBufferList.length; ++i) {
                Object object = this.unprocessedInNetDataGuard;
                synchronized (object) {
                    this.unprocessedInNetData = this.mergeBuffer(this.unprocessedInNetData, encryptedBufferList[i]);
                }
                this.unwrap();
            }
        }
        catch (SSLException sslEx) {
            this.eventHandler.onSSLProcessorClosed();
            throw sslEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHandshaking() {
        SSLEngine sSLEngine = this.sslEngine;
        synchronized (sSLEngine) {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            return handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOutAppData(ByteBuffer[] plainBufferList) throws ClosedChannelException, IOException {
        if (plainBufferList != null) {
            for (ByteBuffer buffer : plainBufferList) {
                LinkedList<ByteBuffer> linkedList = this.outAppDataList;
                synchronized (linkedList) {
                    this.outAppDataList.add(buffer);
                }
            }
        }
    }

    void encrypt() throws ClosedChannelException, IOException {
        try {
            this.wrap();
        }
        catch (IOException sslEx) {
            this.eventHandler.onSSLProcessorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwrap() throws SSLException, ClosedChannelException, IOException {
        Object object = this.unprocessedInNetDataGuard;
        synchronized (object) {
            if (this.unprocessedInNetData.remaining() == 0) {
                return;
            }
        }
        int minAppSize = this.minEncryptedBufferSize;
        boolean isDataDecrypted = false;
        boolean needUnwrap = true;
        boolean needWrap = false;
        boolean nodifyHandshakeFinished = false;
        while (needUnwrap) {
            needUnwrap = false;
            ByteBuffer inAppData = this.memoryManager.acquireMemoryMinSize(minAppSize);
            SSLEngine sSLEngine = this.sslEngine;
            synchronized (sSLEngine) {
                SSLEngineResult engineResult = null;
                Object object2 = this.unprocessedInNetDataGuard;
                synchronized (object2) {
                    engineResult = this.sslEngine.unwrap(this.unprocessedInNetData, inAppData);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    if (inAppData.position() == 0 && engineResult.bytesConsumed() > 0) {
                        LOG.fine("incoming ssl system message (size " + engineResult.bytesConsumed() + ") encrypted by ssl engine");
                    }
                    if (this.unprocessedInNetData.remaining() > 0) {
                        LOG.fine("remaining not decrypted incoming net data (" + this.unprocessedInNetData.remaining() + ")");
                    }
                    if (inAppData.position() > 0) {
                        LOG.fine("incoming app data (size " + inAppData.position() + ") encrypted by ssl engine");
                    }
                }
                if (this.unprocessedInNetData.remaining() > 0 && engineResult.bytesConsumed() > 0) {
                    needUnwrap = true;
                }
                SSLEngineResult.Status status = engineResult.getStatus();
                block8 : switch (status) {
                    case BUFFER_UNDERFLOW: {
                        needUnwrap = false;
                        this.memoryManager.recycleMemory(inAppData);
                        if (!LOG.isLoggable(Level.FINEST)) break;
                        LOG.finest("BufferUnderflow occured (not enough InNet data)");
                        break;
                    }
                    case CLOSED: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("ssl engine closed");
                        }
                        this.memoryManager.recycleMemory(inAppData);
                        throw new ClosedChannelException();
                    }
                    case BUFFER_OVERFLOW: {
                        needUnwrap = true;
                        this.memoryManager.recycleMemory(inAppData);
                        minAppSize += minAppSize;
                        break;
                    }
                    case OK: {
                        inAppData = this.memoryManager.extractAndRecycleMemory(inAppData, engineResult.bytesProduced());
                        if (inAppData.hasRemaining()) {
                            isDataDecrypted = true;
                            this.eventHandler.onDataDecrypted(inAppData);
                        }
                        SSLEngineResult.HandshakeStatus handshakeStatus = engineResult.getHandshakeStatus();
                        switch (handshakeStatus) {
                            case NOT_HANDSHAKING: {
                                break block8;
                            }
                            case NEED_UNWRAP: {
                                needUnwrap = true;
                                break block8;
                            }
                            case NEED_WRAP: {
                                needWrap = true;
                                break block8;
                            }
                            case NEED_TASK: {
                                needUnwrap = true;
                                Runnable task = null;
                                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                                    task.run();
                                }
                                break block8;
                            }
                            case FINISHED: {
                                needUnwrap = true;
                                nodifyHandshakeFinished = true;
                                break block8;
                            }
                        }
                        needUnwrap = false;
                    }
                }
            }
            if (isDataDecrypted) {
                this.eventHandler.onPostDataDecrypted();
            }
            boolean outAppDataListEmpty = false;
            LinkedList<ByteBuffer> linkedList = this.outAppDataList;
            synchronized (linkedList) {
                outAppDataListEmpty = this.outAppDataList.isEmpty();
            }
            if (!outAppDataListEmpty) {
                needWrap = true;
            }
            if (needWrap) {
                this.wrap();
            }
            if (!nodifyHandshakeFinished) continue;
            this.notifyHandshakeFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrap() throws SSLException, ClosedChannelException, IOException {
        int minNetSize = this.minNetBufferSize;
        boolean isDataEncrypted = false;
        boolean needWrap = true;
        boolean needUnwrap = false;
        boolean nodifyHandshakeFinished = false;
        while (needWrap) {
            needWrap = false;
            ByteBuffer outNetData = this.memoryManager.acquireMemoryMinSize(minNetSize);
            SSLEngine sSLEngine = this.sslEngine;
            synchronized (sSLEngine) {
                ByteBuffer outAppData = null;
                LinkedList<ByteBuffer> linkedList = this.outAppDataList;
                synchronized (linkedList) {
                    outAppData = this.outAppDataList.isEmpty() ? ByteBuffer.allocate(0) : this.outAppDataList.remove(0);
                }
                int sizeToEncrypt = outAppData.remaining();
                SSLEngineResult engineResult = this.sslEngine.wrap(outAppData, outNetData);
                if (LOG.isLoggable(Level.FINE)) {
                    if (sizeToEncrypt == 0 && engineResult.bytesProduced() > 0) {
                        LOG.fine("outgoing ssl system message (size " + engineResult.bytesProduced() + ") created by ssl engine");
                    } else if (sizeToEncrypt > 0) {
                        LOG.fine("outgoing app data (size " + sizeToEncrypt + ") encrypted (encrypted size " + outNetData.position() + ")");
                    }
                    if (outAppData.remaining() > 0) {
                        LOG.fine("remaining not encrypted outgoing app data (" + outAppData.remaining() + ")");
                    }
                }
                if (outAppData.remaining() > 0 && engineResult.bytesConsumed() > 0) {
                    needWrap = true;
                }
                if (outAppData.hasRemaining()) {
                    LinkedList<ByteBuffer> linkedList2 = this.outAppDataList;
                    synchronized (linkedList2) {
                        this.outAppDataList.addFirst(outAppData);
                    }
                }
                if (this.outAppDataList.size() > 0 && engineResult.bytesConsumed() > 0) {
                    needWrap = true;
                }
                SSLEngineResult.Status status = engineResult.getStatus();
                block6 : switch (status) {
                    case BUFFER_UNDERFLOW: {
                        needWrap = false;
                        outNetData = this.memoryManager.extractAndRecycleMemory(outNetData, engineResult.bytesProduced());
                        if (!outNetData.hasRemaining()) break;
                        isDataEncrypted = true;
                        this.eventHandler.onDataEncrypted(outAppData, outNetData);
                        break;
                    }
                    case CLOSED: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("ssl engine closed");
                        }
                        this.memoryManager.recycleMemory(outNetData);
                        throw new ClosedChannelException();
                    }
                    case BUFFER_OVERFLOW: {
                        needWrap = true;
                        this.memoryManager.recycleMemory(outNetData);
                        minNetSize += minNetSize;
                        break;
                    }
                    case OK: {
                        outNetData = this.memoryManager.extractAndRecycleMemory(outNetData, engineResult.bytesProduced());
                        if (outNetData.hasRemaining()) {
                            isDataEncrypted = true;
                            this.eventHandler.onDataEncrypted(outAppData, outNetData);
                        }
                        SSLEngineResult.HandshakeStatus handshakeStatus = engineResult.getHandshakeStatus();
                        switch (handshakeStatus) {
                            case NOT_HANDSHAKING: {
                                break block6;
                            }
                            case NEED_UNWRAP: {
                                needUnwrap = true;
                                break block6;
                            }
                            case NEED_WRAP: {
                                needWrap = true;
                                break block6;
                            }
                            case NEED_TASK: {
                                needWrap = true;
                                Runnable task = null;
                                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                                    task.run();
                                }
                                break block6;
                            }
                            case FINISHED: {
                                needWrap = true;
                                nodifyHandshakeFinished = true;
                                break block6;
                            }
                        }
                        needWrap = false;
                    }
                }
            }
            if (needUnwrap) {
                Runnable unwrapTask = new Runnable(){

                    public void run() {
                        try {
                            IoSSLProcessor.this.unwrap();
                        }
                        catch (IOException e) {
                            IoSSLProcessor.this.destroy();
                        }
                    }
                };
                this.executor.execute(unwrapTask);
            }
            if (isDataEncrypted) {
                this.eventHandler.onPostDataEncrypted();
            }
            if (!nodifyHandshakeFinished) continue;
            this.notifyHandshakeFinished();
        }
    }

    private void notifyHandshakeFinished() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            if (this.isClientMode) {
                LOG.fine("handshake has been finished (clientMode)");
            } else {
                LOG.fine("handshake has been finished (serverMode)");
            }
        }
        this.eventHandler.onHandshakeFinished();
    }

    private ByteBuffer mergeBuffer(ByteBuffer first, ByteBuffer second) {
        if (first.remaining() == 0) {
            return second;
        }
        if (second.remaining() == 0) {
            return first;
        }
        ByteBuffer mergedBuffer = ByteBuffer.allocate(first.remaining() + second.remaining());
        mergedBuffer.put(first);
        mergedBuffer.put(second);
        mergedBuffer.flip();
        return mergedBuffer;
    }

    static interface EventHandler {
        public void onHandshakeFinished() throws IOException;

        public void onDataDecrypted(ByteBuffer var1);

        public void onPostDataDecrypted();

        public void onDataEncrypted(ByteBuffer var1, ByteBuffer var2) throws IOException;

        public void onPostDataEncrypted() throws IOException;

        public void onSSLProcessorClosed() throws IOException;
    }
}

