/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.Resource;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HandlerChain
implements IHandler,
IConnectHandler,
IDataHandler,
IDisconnectHandler,
IConnectionTimeoutHandler,
IIdleTimeoutHandler,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(HandlerChain.class.getName());
    @Resource
    private IServer server = null;
    private final List<IHandler> handlers = new ArrayList<IHandler>();
    private final List<ILifeCycle> lifeCycleChain = new ArrayList<ILifeCycle>();
    private boolean isOnConnectPathMultithreaded = false;
    private final List<IConnectHandler> connectHandlerChain = new ArrayList<IConnectHandler>();
    private boolean isOnDataPathMultithreaded = false;
    private final List<IDataHandler> dataHandlerChain = new ArrayList<IDataHandler>();
    private boolean isOnDisconnectPathMultithreaded = false;
    private final List<IDisconnectHandler> disconnectHandlerChain = new ArrayList<IDisconnectHandler>();
    private boolean isOnIdleTimeoutPathMultithreaded = false;
    private final List<IIdleTimeoutHandler> idleTimeoutHandlerChain = new ArrayList<IIdleTimeoutHandler>();
    private boolean isOnConnectionTimeoutPathMultithreaded = false;
    private final List<IConnectionTimeoutHandler> connectionTimeoutHandlerChain = new ArrayList<IConnectionTimeoutHandler>();

    public HandlerChain() {
    }

    public HandlerChain(List<IHandler> handlers) {
        for (IHandler hdl : handlers) {
            this.addLast(hdl);
        }
    }

    @Override
    public void onInit() {
        for (IHandler handler : this.handlers) {
            ConnectionUtils.injectServerField(this.server, handler);
        }
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onInit();
        }
    }

    @Override
    public void onDestroy() throws IOException {
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onDestroy();
        }
    }

    public void addLast(IHandler handler) {
        if (handler instanceof HandlerChain) {
            throw new RuntimeException("a nested chains are not supported");
        }
        this.handlers.add(handler);
        this.computePath();
    }

    private void computePath() {
        this.lifeCycleChain.clear();
        this.connectHandlerChain.clear();
        this.isOnConnectPathMultithreaded = false;
        this.dataHandlerChain.clear();
        this.isOnDataPathMultithreaded = false;
        this.disconnectHandlerChain.clear();
        this.isOnDisconnectPathMultithreaded = false;
        this.idleTimeoutHandlerChain.clear();
        this.isOnIdleTimeoutPathMultithreaded = false;
        this.connectionTimeoutHandlerChain.clear();
        this.isOnConnectionTimeoutPathMultithreaded = false;
        for (IHandler handler : this.handlers) {
            ConnectionUtils.HandlerInfo handlerInfo = ConnectionUtils.getHandlerInfo(handler);
            if (handlerInfo.isLifeCycle()) {
                this.lifeCycleChain.add((ILifeCycle)((Object)handler));
            }
            if (handlerInfo.isConnectHandler()) {
                this.connectHandlerChain.add((IConnectHandler)handler);
                boolean bl = this.isOnConnectPathMultithreaded = this.isOnConnectPathMultithreaded || handlerInfo.isConnectHandlerMultithreaded();
            }
            if (handlerInfo.isDataHandler()) {
                this.dataHandlerChain.add((IDataHandler)handler);
                boolean bl = this.isOnDataPathMultithreaded = this.isOnDataPathMultithreaded || handlerInfo.isDataHandlerMultithreaded();
            }
            if (handlerInfo.isDisconnectHandler()) {
                this.disconnectHandlerChain.add((IDisconnectHandler)handler);
                boolean bl = this.isOnDisconnectPathMultithreaded = this.isOnDisconnectPathMultithreaded || handlerInfo.isDisconnectHandlerMultithreaded();
            }
            if (handlerInfo.isIdleTimeoutHandler()) {
                this.idleTimeoutHandlerChain.add((IIdleTimeoutHandler)handler);
                boolean bl = this.isOnIdleTimeoutPathMultithreaded = this.isOnIdleTimeoutPathMultithreaded || handlerInfo.isIdleTimeoutHandlerMultithreaded();
            }
            if (!handlerInfo.isConnectionTimeoutHandler()) continue;
            this.connectionTimeoutHandlerChain.add((IConnectionTimeoutHandler)handler);
            this.isOnConnectionTimeoutPathMultithreaded = this.isOnConnectionTimeoutPathMultithreaded || handlerInfo.isConnectionTimeoutHandlerMultithreaded();
        }
    }

    @Override
    @Execution(value=0)
    public boolean onConnect(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.connectHandlerChain.isEmpty()) {
            return false;
        }
        if (this.isOnConnectPathMultithreaded) {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            HandlerChain.this.callOnConnectCallback(connection);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("Error occured by calling onConnect callback " + ioe.toString());
                        }
                    }
                }
            };
            connection.getWorkerpool().execute(task);
        } else {
            this.callOnConnectCallback(connection);
        }
        return true;
    }

    private boolean callOnConnectCallback(INonBlockingConnection connection) throws IOException {
        for (IConnectHandler connectHandler : this.connectHandlerChain) {
            boolean result = connectHandler.onConnect(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    @Execution(value=0)
    public boolean onData(final INonBlockingConnection connection) throws IOException {
        if (this.dataHandlerChain.isEmpty()) {
            return false;
        }
        if (this.isOnDataPathMultithreaded) {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            HandlerChain.this.callOnDataCallback(connection);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("Error occured by calling onData callback " + ioe.toString());
                        }
                    }
                }
            };
            connection.getWorkerpool().execute(task);
        } else {
            this.callOnDataCallback(connection);
        }
        return true;
    }

    private boolean callOnDataCallback(INonBlockingConnection connection) throws IOException {
        for (IDataHandler dataHandler : this.dataHandlerChain) {
            boolean result = dataHandler.onData(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    @Execution(value=0)
    public boolean onDisconnect(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.disconnectHandlerChain.isEmpty()) {
            return false;
        }
        if (this.isOnDisconnectPathMultithreaded) {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            HandlerChain.this.callOnDisconnectCallback(connection);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("Error occured by calling onDisconnect callback " + ioe.toString());
                        }
                    }
                }
            };
            connection.getWorkerpool().execute(task);
        } else {
            this.callOnDisconnectCallback(connection);
        }
        return true;
    }

    private boolean callOnDisconnectCallback(INonBlockingConnection connection) throws IOException {
        for (IDisconnectHandler disconnectHandler : this.disconnectHandlerChain) {
            boolean result = disconnectHandler.onDisconnect(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    @Execution(value=0)
    public boolean onIdleTimeout(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.idleTimeoutHandlerChain.isEmpty()) {
            return false;
        }
        if (this.isOnIdleTimeoutPathMultithreaded) {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            HandlerChain.this.callOnIdleTimeoutCallback(connection);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("Error occured by calling onIdleTimeout callback " + ioe.toString());
                        }
                    }
                }
            };
            connection.getWorkerpool().execute(task);
        } else {
            this.callOnIdleTimeoutCallback(connection);
        }
        return true;
    }

    private boolean callOnIdleTimeoutCallback(INonBlockingConnection connection) throws IOException {
        for (IIdleTimeoutHandler idleTimeoutHandler : this.idleTimeoutHandlerChain) {
            boolean result = idleTimeoutHandler.onIdleTimeout(connection);
            if (!result) continue;
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
        }
        connection.close();
        return true;
    }

    @Override
    @Execution(value=0)
    public boolean onConnectionTimeout(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.connectionTimeoutHandlerChain.isEmpty()) {
            return false;
        }
        if (this.isOnConnectionTimeoutPathMultithreaded) {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            HandlerChain.this.callOnConnectionTimeoutCallback(connection);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("Error occured by calling onConnectionTimeout callback " + ioe.toString());
                        }
                    }
                }
            };
            connection.getWorkerpool().execute(task);
        } else {
            this.callOnConnectionTimeoutCallback(connection);
        }
        return true;
    }

    private boolean callOnConnectionTimeoutCallback(INonBlockingConnection connection) throws IOException {
        for (IConnectionTimeoutHandler connectionTimeoutHandler : this.connectionTimeoutHandlerChain) {
            boolean result = connectionTimeoutHandler.onConnectionTimeout(connection);
            if (!result) continue;
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] closing connection because coonection timeout has been occured and timeout handler returns true)");
        }
        connection.close();
        return true;
    }
}

