/**
 * Copyright (C) 2016-2021 Xilinx, Inc
 * Copyright (C) 2023 Advanced Micro Devices, Inc. - All rights reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"). You may
 * not use this file except in compliance with the License. A copy of the
 * License is located at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

#define XDP_PLUGIN_SOURCE

#include "pl_deadlock_cb.h"
#include "pl_deadlock_plugin.h"

namespace xdp {
  static PLDeadlockPlugin plDeadlockPluginInstance;

  static void updateDevicePLDeadlock(void* handle)
  {
    plDeadlockPluginInstance.updateDevice(handle);
  }

  static void flushDevicePLDeadlock(void* handle)
  {
    plDeadlockPluginInstance.flushDevice(handle);
  }

} // end namespace xdp 

extern "C"
void updateDevicePLDeadlock(void* handle) 
{
  xdp::updateDevicePLDeadlock(handle);
}

extern "C"
void flushDevicePLDeadlock(void* handle)
{
  xdp::flushDevicePLDeadlock(handle);
}
