#!/bin/bash

# ARG_OPTIONAL_SINGLE([flavor],[],[Which distribution to base the container upon],[fedora])
# ARG_OPTIONAL_SINGLE([public-key],[i],[Which identity file to use to SSH login to the container (looks for first .pub file under $HOME/.ssh by default)])
# ARG_OPTIONAL_REPEATED([package],[p],[Which additional package(s) to add to the test image.])
# ARG_OPTIONAL_SINGLE([name],[n],[Name of the test image],[ssg_test_suite])
# DEFINE_SCRIPT_DIR([])
# ARG_TYPE_GROUP_SET([flavors],[FLAVOR],[flavor],[fedora,centos,rhel,rhel8])
# ARG_HELP([Build a podman image to be used with the SSG test suite])
# ARGBASH_GO()
# needed because of Argbash --> m4_ignore([
### START OF CODE GENERATED BY Argbash v2.10.0 one line above ###
# Argbash is a bash code generator used to get arguments parsing right.
# Argbash is FREE SOFTWARE, see https://argbash.io for more info


die()
{
	local _ret="${2:-1}"
	test "${_PRINT_HELP:-no}" = yes && print_help >&2
	echo "$1" >&2
	exit "${_ret}"
}

# validators

flavors()
{
	local _allowed=("fedora" "centos" "rhel" "rhel8") _seeking="$1"
	for element in "${_allowed[@]}"
	do
		test "$element" = "$_seeking" && echo "$element" && return 0
	done
	die "Value '$_seeking' (of argument '$2') doesn't match the list of allowed values: 'fedora', 'centos', 'rhel' and 'rhel8'" 4
}


begins_with_short_option()
{
	local first_option all_short_options='ipnh'
	first_option="${1:0:1}"
	test "$all_short_options" = "${all_short_options/$first_option/}" && return 1 || return 0
}

# THE DEFAULTS INITIALIZATION - OPTIONALS
_arg_flavor="fedora"
_arg_public_key=
_arg_package=()
_arg_name="ssg_test_suite"


print_help()
{
	printf '%s\n' "Build a podman image to be used with the SSG test suite"
	printf 'Usage: %s [--flavor <FLAVOR>] [-i|--public-key <arg>] [-p|--package <arg>] [-n|--name <arg>] [-h|--help]\n' "$0"
	printf '\t%s\n' "--flavor: Which distribution to base the container upon. Can be one of: 'fedora', 'centos', 'rhel' and 'rhel8' (default: 'fedora')"
	printf '\t%s\n' "-i, --public-key: Which identity file to use to SSH login to the container (looks for first .pub file under $HOME/.ssh by default) (no default)"
	printf '\t%s\n' "-p, --package: Which additional package(s) to add to the test image. (empty by default)"
	printf '\t%s\n' "-n, --name: Name of the test image (default: 'ssg_test_suite')"
	printf '\t%s\n' "-h, --help: Prints help"
}


parse_commandline()
{
	while test $# -gt 0
	do
		_key="$1"
		case "$_key" in
			--flavor)
				test $# -lt 2 && die "Missing value for the optional argument '$_key'." 1
				_arg_flavor="$(flavors "$2" "flavor")" || exit 1
				shift
				;;
			--flavor=*)
				_arg_flavor="$(flavors "${_key##--flavor=}" "flavor")" || exit 1
				;;
			-i|--public-key)
				test $# -lt 2 && die "Missing value for the optional argument '$_key'." 1
				_arg_public_key="$2"
				shift
				;;
			--public-key=*)
				_arg_public_key="${_key##--public-key=}"
				;;
			-i*)
				_arg_public_key="${_key##-i}"
				;;
			-p|--package)
				test $# -lt 2 && die "Missing value for the optional argument '$_key'." 1
				_arg_package+=("$2")
				shift
				;;
			--package=*)
				_arg_package+=("${_key##--package=}")
				;;
			-p*)
				_arg_package+=("${_key##-p}")
				;;
			-n|--name)
				test $# -lt 2 && die "Missing value for the optional argument '$_key'." 1
				_arg_name="$2"
				shift
				;;
			--name=*)
				_arg_name="${_key##--name=}"
				;;
			-n*)
				_arg_name="${_key##-n}"
				;;
			-h|--help)
				print_help
				exit 0
				;;
			-h*)
				print_help
				exit 0
				;;
			*)
				_PRINT_HELP=yes die "FATAL ERROR: Got an unexpected argument '$1'" 1
				;;
		esac
		shift
	done
}

parse_commandline "$@"

# OTHER STUFF GENERATED BY Argbash
script_dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)" || { echo "Couldn't determine the script's running directory, which probably matters, bailing out" >&2; exit 2; }
# Validation of values


### END OF CODE GENERATED BY Argbash (sortof) ### ])
# [ <-- needed because of Argbash

public_key=$_arg_public_key
test -n "$public_key" || public_key=$(ls "$HOME"/.ssh/*.pub | head -n 1)
test -f "$public_key" || die "Couldn't find your public key, specify its location as the script's argument."

# build without context
podman build --build-arg ADDITIONAL_PACKAGES="${_arg_package[*]}" --build-arg CLIENT_PUBLIC_KEY="$(cat "$public_key")" -t "${_arg_name}" - < "$script_dir/../Dockerfiles/test_suite-$_arg_flavor"

# ] <-- needed because of Argbash
