---
tweet: What's new in Joplin 2.9
forum_url: https://discourse.joplinapp.org/t/28661
---

# What's new in Joplin 2.9

## Proxy support

Both the desktop and mobile application now support proxies thanks to the work of Jason Williams. This will allow you to use the apps in particular when you are behind a company proxy.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20221216-proxy-support.png)

## New PDF viewer

The desktop application now features a new PDF viewer thanks to the work of Asrient during GSoC.

The main advantage for now is that this viewer preserves the last PDF page that was read. In the next version, the viewer will also include a way to annotate PDF files.

##  Multi-language spell checking

The desktop app include a multi-language spell checking features, which allows you, for example, to spell-check notes in your native language and in English.

## New mobile text editor

Writing formatted notes on mobile has always been cumbersome due to the need to enter special format characters like `*` or `[`, etc.

Thanks to the work of Henry Heino during GSoC, writing notes on the go is now easier thanks to an improved Markdown editor.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20221216-mobile-beta-editor.png)

The most visible feature is the addition of a toolbar, which helps input those special characters, like on desktop.

Moreover Henry made a lot of subtle but useful improvements to the editor, for example to improve the note appearance, to improve list continuation, etc. Search within a note is now also supported as well as spell-checking.

At a more technical level, Henry also added many test units to ensure that the editor remains robust and reliable.

To enable the feature, go to the configuration screen and selected "Opt-in to the editor beta". It is already very stable so we will probably promote it to be the main editor from the next version.

## Improved alignment of notebook icons

Previously, when you would assign an icon to a notebook, it would shift the title to the right, but notebook without an icon would not. It means that notebooks with and without an icon would not be vertically aligned.

To tidy things up, this new version adds a default icons to notebooks without an explicitly assigned icon. This result in the notebook titles being correctly vertically aligned.

Note that this feature is only enabled if you use custom icons - otherwise it will simply display the notebook titles without any default icons, as before.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20221216-notebook-icons.png)

## Improved handling of file attachments

Self Not Found made a number of small but useful improvements to attachment handling, including increasing the maximum size to 200MB, adding support for attaching multiple files, and fixing issues with synchronising attachments via proxy.

## Fixed filesystem sync on mobile

This was a long and complex change due to the need to support new Android APIs but hopefully that should now be working again, thanks to the work of jd1378.

So you can now sync again your notes with Syncthing and other file-based synchronisation systems.

## And more...

In total this new desktop version includes 36 improvements, bug fixes, and security fixes.

As always, a lot of work went into the Android and iOS app too, which include 37 improvements, bug fixes, and security fixes.

See here for the changelogs:

- [Desktop app changelog](https://joplinapp.org/help/about/changelog/desktop)
- [Android app changelog](https://joplinapp.org/help/about/changelog/android/)

## About the Android version

Unfortunately we cannot publish the Android version because it is based on a framework version that Google does not accept. To upgrade the app a lot of changes are needed and another round of pre-releases, and therefore there will not be a 2.9 version for Google Play. You may however download the official APK directly from there: [Android 2.9 Official Release](https://github.com/laurent22/joplin-android/releases/tag/android-v2.9.8)

This is the reality of app stores in general - small developers being imposed never ending new requirements by all-powerful companies, and by the time a version is finally ready we can't even publish it because yet more requirements are in place.

For the record the current 2.9 app works perfectly fine. It targets Android 11, which is only 2 years old and is still supported (and installed on millions of phones). Google requires us to target Android 12 which only came out last year.