/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import java.io.IOException;

public class FeignException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    private int status;
    private byte[] content;

    protected FeignException(String message, Throwable cause) {
        super(message, cause);
    }

    protected FeignException(String message, Throwable cause, byte[] content) {
        super(message, cause);
        this.content = content;
    }

    protected FeignException(String message) {
        super(message);
    }

    protected FeignException(int status, String message, byte[] content) {
        super(message);
        this.status = status;
        this.content = content;
    }

    public int status() {
        return this.status;
    }

    public byte[] content() {
        return this.content;
    }

    public String contentUTF8() {
        return new String(this.content, Util.UTF_8);
    }

    static FeignException errorReading(Request request, Response ignored, IOException cause) {
        return new FeignException(String.format("%s reading %s %s", new Object[]{cause.getMessage(), request.httpMethod(), request.url()}), cause, request.body());
    }

    public static FeignException errorStatus(String methodKey, Response response) {
        String message = String.format("status %s reading %s", response.status(), methodKey);
        byte[] body = new byte[]{};
        try {
            if (response.body() != null) {
                body = Util.toByteArray(response.body().asInputStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new FeignException(response.status(), message, body);
    }

    static FeignException errorExecuting(Request request, IOException cause) {
        return new RetryableException(String.format("%s executing %s %s", new Object[]{cause.getMessage(), request.httpMethod(), request.url()}), request.httpMethod(), cause, null);
    }
}

