/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database.load;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerFilterConfig;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.ContextMenuTreeNodeSpecial;

public class TreeNodeFilter
extends ContextMenuTreeNodeSpecial
implements IToolTipProvider {
    public TreeNodeFilter(@NotNull DBNNode parent) {
        super(parent);
    }

    public String getText(Object element) {
        return UINavigatorMessages.navigator_nodes_filtered_by_settings_text;
    }

    public String getToolTipText(Object element) {
        return UINavigatorMessages.navigator_nodes_filtered_by_settings_tip;
    }

    @Override
    public boolean handleDefaultAction(@NotNull DatabaseNavigatorTree navigatorTree) {
        this.configureFilters(navigatorTree);
        return true;
    }

    @Override
    public void fillContextMenu(@NotNull MenuManager menu, final @NotNull DatabaseNavigatorTree navigatorTree) {
        menu.add((IAction)new Action(UINavigatorMessages.actions_navigator_configure_filters){

            public void run() {
                TreeNodeFilter.this.configureFilters(navigatorTree);
            }
        });
    }

    public void configureFilters(@NotNull DatabaseNavigatorTree navigatorTree) {
        DBNNode dBNNode = this.getParent();
        if (dBNNode instanceof DBNDatabaseNode) {
            DBNDatabaseNode dbNode = (DBNDatabaseNode)dBNNode;
            NavigatorHandlerFilterConfig.configureFilters(navigatorTree.getShell(), dbNode);
        }
    }
}

