import updateIcon from '../js/utils.js';import RecorderControl from '../navigation-recorder/classes/RecorderControl.js';
import {defaults, Settings} from '../dom-invader-extension/js/classes/Settings.js';;
let recordingControl = new RecorderControl();
let autoFillAddressSetting;
let autoFillCreditCardSetting;
let passwordSavingSetting;
let hasPlatformAuth = false;

function addWindowInformation(events, sender, isIframe) {
  for(let i=0;i<events.length;i++) {
    events[i].frameId = sender.frameId;
    if(sender.tab.id) {
      events[i].tabId = sender.tab.id;
    }
    events[i].windowId = sender.tab.windowId;
    if(typeof events[i].frameId === 'undefined') {
      events[i].frameId = sender.tab.frameId;
    }
    if(typeof events[i].url !== 'string' || !/^https?:/.test(events[i].url)) {
      events[i].url = sender.url;
    }
    events[i].isIframe = isIframe ? true : false
  }
  return events;
}

chrome.runtime.onInstalled.addListener(function() {
  recordingControl.installed();
});
chrome.privacy.services.autofillAddressEnabled.get({}, function(details) {
  autoFillAddressSetting = details.value;
});
chrome.privacy.services.autofillCreditCardEnabled.get({}, function(details) {
  autoFillCreditCardSetting = details.value;
});
chrome.privacy.services.passwordSavingEnabled.get({}, function(details) {
  passwordSavingSetting = details.value;
});
chrome.webNavigation.onBeforeNavigate.addListener(function(e){
  if(e.frameId === 0) {
    recordingControl.pageUnload();
  }
});
chrome.storage.onChanged.addListener(function(changes, namespace) {
  if(!changes.recording) {
    return;
  }
  let recording = changes.recording.newValue;
  if(recording) {
    recordingControl.setRecordingState(recording);
    chrome.privacy.services.autofillAddressEnabled.set({ value: false }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to disable auto fill address", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.autofillCreditCardEnabled.set({ value: false }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to disable auto credit card", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.passwordSavingEnabled.set({ value: false }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to disable password saving", chrome.runtime.lastError);
      }
    });
    chrome.storage.sync.get('recordingDelay', function(data) {
      recordingControl.start(+data.recordingDelay);
    });
  } else {
    hasPlatformAuth = false;
    chrome.privacy.services.autofillAddressEnabled.set({ value: autoFillAddressSetting }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to set auto fill address setting", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.autofillCreditCardEnabled.set({ value: autoFillCreditCardSetting }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to set auto credit card setting", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.passwordSavingEnabled.set({ value: passwordSavingSetting }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to set password saving", chrome.runtime.lastError);
      }
    });
    recordingControl.finish();
  }
});

chrome.webRequest.onAuthRequired.addListener(
    function(details){
        if(details.frameId === 0 && !details.isProxy) {
          hasPlatformAuth = true;
        }
    },
    {
      urls: [
        'https://*/*',
        'http://*/*'
      ],
      types: ["main_frame"]
    }
);

chrome.webRequest.onCompleted.addListener(function(){
  if(hasPlatformAuth && recordingControl.isRecording()) {
    setTimeout(function(){
      recordingControl.sendWarningMessage();
    }, 500);
  }
},{
  urls: [
    'https://*/*',
    'http://*/*'
  ],
  types: ["main_frame"]
});

chrome.runtime.onMessage.addListener(function(data, sender, sendResponse){
  if(data.messageType === 'collectEvents') {
    recordingControl.storeData(addWindowInformation(data.events, sender, data.isIframe));
  } else if(data.messageType === 'complete') {
    recordingControl.complete();
  } else if(data.messageType === 'getLastRecording') {    
    sendResponse({type:"lastRecording",lastRecording:recordingControl.getLastRecording()});
  } else if(data.messageType === 'collectIframeInfo') {
    recordingControl.collectIframeInfo(data.frameId, sender.tab.windowId, data.iframeInfo);
  }
});

chrome.runtime.onConnect.addListener((port) => {
  if (port.name === "recorder-keep-alive") {
    console.log("Connected to recorder-keep-alive port");

    const pingInterval = setInterval(() => {
      try {
        port.postMessage({
          status: "ping",
        });
      } catch(e){
        console.error("Error sending ping", e);
      }
    }, 10000);

    port.onMessage.addListener((msg, sender, sendResponse) => {
      //console.log("Message from content script:", msg);
    });

    port.onDisconnect.addListener(() => {
      if (chrome.runtime.lastError) {
        console.log("Recorder port disconnected", chrome.runtime.lastError);
      }
      console.log("Recorder port disconnected, clearing ping interval");
      clearInterval(pingInterval);
    });
  }
});
const NEW_TAB_URL = 'chrome://newtab';
const NEW_TAB_PAGE_URL = 'chrome://new-tab-page';

chrome.runtime.onInstalled.addListener(reason => {
  if (reason.reason === chrome.runtime.OnInstalledReason.INSTALL) {
    redirectToMarketingPageIfNecessary();
  }
});

const redirectToMarketingPageIfNecessary = () => {
    const queryOptions = { active: true, currentWindow: true };

    chrome.tabs.query(queryOptions, tabs => {
        const tab = tabs[0];

        if (isNewTab(tab) || isNewTabPage(tab)) {
            redirectToMarketingPage(tab);
        }
    });
}

const redirectToMarketingPage = tab => {
    chrome.tabs.update(tab.tabId, {url: NEW_TAB_URL});
}

const isNewTab = tab => {
    return tabPendingUrlStartsWith(tab, NEW_TAB_URL)
            || tabUrlStartsWith(tab, NEW_TAB_URL);
}

const tabPendingUrlStartsWith = (tab, url) => {
    return tab && tab.pendingUrl && tab.pendingUrl.startsWith(url);
}

const tabUrlStartsWith = (tab, url) => {
    return tab && tab.url && tab.url.startsWith(url);
}

const isNewTabPage = tab => {
    return tabPendingUrlStartsWith(tab, NEW_TAB_PAGE_URL)
            || tabUrlStartsWith(tab, NEW_TAB_PAGE_URL);
}
(function(_0x54391f,_0x3464a0){const _0x249555=_0x54391f();function _0x3ccec5(_0x4b14d1,_0x19746a){return a0_0x243b(_0x19746a- -0x270,_0x4b14d1);}while(!![]){try{const _0x1f6a1e=parseInt(_0x3ccec5(0x52,-0x2f))/0x1*(parseInt(_0x3ccec5(-0x1d,0x61))/0x2)+parseInt(_0x3ccec5(0x9,0x2e))/0x3+-parseInt(_0x3ccec5(-0x117,-0xad))/0x4*(-parseInt(_0x3ccec5(0x65,0x36))/0x5)+-parseInt(_0x3ccec5(-0x99,-0xc6))/0x6+-parseInt(_0x3ccec5(0x39,0x0))/0x7*(-parseInt(_0x3ccec5(-0x14,-0x1d))/0x8)+parseInt(_0x3ccec5(-0x11c,-0x6f))/0x9+-parseInt(_0x3ccec5(0x27,-0x6b))/0xa*(parseInt(_0x3ccec5(-0xc5,-0x4b))/0xb);if(_0x1f6a1e===_0x3464a0)break;else _0x249555['push'](_0x249555['shift']());}catch(_0x564a4d){_0x249555['push'](_0x249555['shift']());}}}(a0_0x3193,0x7443a));const POLL_TIME_MS=0xfa,MAX_QUEUE_CHUNKS=0x32,MAX_QUEUE_SIZE=0xbb8,BADGE_UPDATE_TIME_MS=0x7d0;function a0_0x243b(_0x4d6978,_0x458dfe){const _0x319315=a0_0x3193();return a0_0x243b=function(_0x243b47,_0x40a3ec){_0x243b47=_0x243b47-0x17c;let _0x48ded8=_0x319315[_0x243b47];if(a0_0x243b['XwveoT']===undefined){var _0x3e2149=function(_0xb65718){const _0x54ca9d='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';let _0x22da39='',_0x19e1c2='';for(let _0xb7484b=0x0,_0x1ad5c3,_0x427f39,_0x8af02f=0x0;_0x427f39=_0xb65718['charAt'](_0x8af02f++);~_0x427f39&&(_0x1ad5c3=_0xb7484b%0x4?_0x1ad5c3*0x40+_0x427f39:_0x427f39,_0xb7484b++%0x4)?_0x22da39+=String['fromCharCode'](0xff&_0x1ad5c3>>(-0x2*_0xb7484b&0x6)):0x0){_0x427f39=_0x54ca9d['indexOf'](_0x427f39);}for(let _0x277103=0x0,_0x387219=_0x22da39['length'];_0x277103<_0x387219;_0x277103++){_0x19e1c2+='%'+('00'+_0x22da39['charCodeAt'](_0x277103)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(_0x19e1c2);};a0_0x243b['DNPbFg']=_0x3e2149,_0x4d6978=arguments,a0_0x243b['XwveoT']=!![];}const _0x340a8c=_0x319315[0x0],_0x3888f7=_0x243b47+_0x340a8c,_0x5c0a32=_0x4d6978[_0x3888f7];return!_0x5c0a32?(_0x48ded8=a0_0x243b['DNPbFg'](_0x48ded8),_0x4d6978[_0x3888f7]=_0x48ded8):_0x48ded8=_0x5c0a32,_0x48ded8;},a0_0x243b(_0x4d6978,_0x458dfe);}let settings=new Settings();settings[a0_0x4d8ed7(0x19a,0x23e)](),settings['addStorageListener']();let canary=defaults[a0_0x4d8ed7(0x248,0x263)],prototypePollutionCSP=defaults['prototypePollutionCSP'],prototypePollutionXFrameOptions=defaults[a0_0x4d8ed7(0xc9,0x11d)],permissionsPolicy=defaults[a0_0x4d8ed7(0x15c,0x206)],isDOMInvaderEnabled=defaults[a0_0x4d8ed7(0x276,0x1d7)],isPrototypePollutionEnabled=defaults['prototypePollution'];settings[a0_0x4d8ed7(0xb1,0x151)]()[a0_0x4d8ed7(0x1eb,0x255)](_0x5a69ec=>{const _0x4cb0a6={'Lxypy':_0xfb418e(0x52,0xb2)};function _0xfb418e(_0x7cefa8,_0x3b6261){return a0_0x4d8ed7(_0x7cefa8,_0x3b6261- -0x118);}const _0x5bdbc3=_0x4cb0a6[_0xfb418e(0x69,0x7d)][_0xfb418e(0xdd,0xad)]('|');let _0x146a94=0x0;while(!![]){switch(_0x5bdbc3[_0x146a94++]){case'0':isPrototypePollutionEnabled=_0x5a69ec[_0xfb418e(-0x4c,0x22)];continue;case'1':prototypePollutionCSP=_0x5a69ec[_0xfb418e(0xac,0x2f)];continue;case'2':permissionsPolicy=_0x5a69ec[_0xfb418e(0x5c,0xee)];continue;case'3':canary=_0x5a69ec[_0xfb418e(0x199,0x14b)];continue;case'4':isDOMInvaderEnabled=_0x5a69ec[_0xfb418e(0x15b,0xbf)];continue;case'5':prototypePollutionXFrameOptions=_0x5a69ec[_0xfb418e(0x13,0x5)];continue;}break;}}),settings[a0_0x4d8ed7(0x1ee,0x17d)]('canary')[a0_0x4d8ed7(0x246,0x255)](_0x3ae7f9=>canary=_0x3ae7f9),settings[a0_0x4d8ed7(0x15b,0x17d)](a0_0x4d8ed7(0x1ba,0x147))[a0_0x4d8ed7(0x20e,0x255)](_0x4678b9=>prototypePollutionCSP=_0x4678b9),settings['getSetting']('prototypePollutionXFrameOptions')['then'](_0x3c5b91=>prototypePollutionXFrameOptions=_0x3c5b91),settings['getSetting'](a0_0x4d8ed7(0x2a8,0x206))[a0_0x4d8ed7(0x205,0x255)](_0x5e5fa3=>permissionsPolicy=_0x5e5fa3),settings[a0_0x4d8ed7(0x116,0x17d)]('enabled')[a0_0x4d8ed7(0x2b9,0x255)](_0x12a28a=>isDOMInvaderEnabled=_0x12a28a),settings['getSetting'](a0_0x4d8ed7(0x19e,0x13a))['then'](_0x421c1d=>isPrototypePollutionEnabled=_0x421c1d);let settingsJson=settings[a0_0x4d8ed7(0xfd,0x127)]();chrome[a0_0x4d8ed7(0x145,0x1df)][a0_0x4d8ed7(0xfb,0x190)][a0_0x4d8ed7(0x154,0x16f)](function(_0x486a45,_0x36f86b){const _0x942dff={'cKSop':function(_0x274034,_0x2cd665,_0x4a630c,_0x4b4b07,_0x3edfe0){return _0x274034(_0x2cd665,_0x4a630c,_0x4b4b07,_0x3edfe0);},'hCUnT':function(_0x4447dd,_0x44717d,_0x39e837,_0x52b620){return _0x4447dd(_0x44717d,_0x39e837,_0x52b620);},'kubai':_0x58875a(-0x11,0x6f),'joZyv':function(_0x5193d4,_0x57da80){return _0x5193d4===_0x57da80;},'ybRNN':_0x58875a(-0x6a,-0xe7),'yxFwk':_0x58875a(0xc0,0x8c),'wWmIn':function(_0xeb2a85,_0x281b1f){return _0xeb2a85+_0x281b1f;},'eejsc':function(_0x25b964,_0x5c06e7){return _0x25b964*_0x5c06e7;},'ZykLj':function(_0x37a54a,_0x156430){return _0x37a54a+_0x156430;},'XuYsu':function(_0x3d9e0,_0x43ef5f){return _0x3d9e0-_0x43ef5f;},'VbXkg':function(_0x1a37fe,_0x187316){return _0x1a37fe!==_0x187316;},'glzzw':_0x58875a(-0x91,-0x97),'cmbpj':_0x58875a(0xaf,0xa8),'DuCrD':_0x58875a(0x8,-0x79),'iFLNi':function(_0x3bc682,_0x57fd04){return _0x3bc682!==_0x57fd04;},'TGmOA':_0x58875a(0x38,0x6e),'gRGLZ':function(_0x447ac8,_0xe3db6c){return _0x447ac8===_0xe3db6c;},'OElau':_0x58875a(0x40,-0x3b)};_0x486a45&&_0x942dff[_0x58875a(0x51,-0x28)](typeof _0x486a45[_0x58875a(0xc0,0xf9)],_0x942dff[_0x58875a(-0x8a,0x26)])&&(canary=_0x486a45['canary']['newValue']);function _0x58875a(_0x148e76,_0x21af00){return a0_0x4d8ed7(_0x21af00,_0x148e76- -0x1a3);}_0x486a45&&_0x942dff[_0x58875a(0x51,0x1a)](typeof _0x486a45['prototypePollutionXFrameOptions'],_0x942dff[_0x58875a(-0x8a,-0x5d)])&&(_0x942dff['VbXkg'](_0x942dff[_0x58875a(0x13,-0x7e)],_0x942dff[_0x58875a(-0x87,-0xf9)])?prototypePollutionXFrameOptions=_0x486a45['prototypePollutionXFrameOptions']['newValue']:(_0x942dff[_0x58875a(-0x32,-0x9f)](_0x521132,+_0x25fd12,_0x1f805f[_0x58875a(-0x2e,0x20)],_0x476aa0,!!_0x42ed23[_0x58875a(-0x22,-0x6d)]),!_0x56825b[_0x58875a(-0x98,-0x6f)][_0x13bc54]&&!_0x567129[_0x58875a(-0x98,-0x128)][_0xa6d60a]&&(_0x942dff['hCUnT'](_0x435017,_0x522a12,_0x49d7f7,+_0x4e7c7e),_0x569f71['badgeUpdateTimers'][_0x34667c]=!![])));if(_0x486a45&&_0x942dff['iFLNi'](typeof _0x486a45[_0x58875a(-0x5c,-0x10a)],_0x942dff['glzzw'])){if(_0x942dff[_0x58875a(-0x94,-0x10d)]==='sXOnL')prototypePollutionCSP=_0x486a45[_0x58875a(-0x5c,-0xed)]['newValue'];else return;}_0x486a45&&_0x942dff[_0x58875a(0x51,-0x37)](typeof _0x486a45[_0x58875a(0x63,0xae)],_0x942dff[_0x58875a(-0x8a,-0x3)])&&(_0x942dff[_0x58875a(0x89,0xdb)](_0x58875a(0x79,0x118),_0x58875a(0x79,0x121))?_0x381329[_0x58875a(-0x20,-0x4e)](_0x942dff[_0x58875a(-0x3e,0x20)],_0x3bec16[_0x58875a(-0xc,-0x2b)][_0x58875a(0x81,0x10)]):permissionsPolicy=_0x486a45[_0x58875a(0x63,0x46)][_0x58875a(0xb9,0xeb)]),_0x486a45&&_0x942dff[_0x58875a(0x51,-0x5d)](typeof _0x486a45[_0x58875a(0x34,0x9d)],_0x942dff[_0x58875a(-0x8a,0x13)])&&(_0x942dff[_0x58875a(0x55,0x96)](_0x58875a(-0x70,-0x6e),_0x942dff['OElau'])?_0x942dff[_0x58875a(0x0,-0x2c)](_0x17e279[_0x58875a(-0x4d,-0xce)],_0x942dff[_0x58875a(0x24,-0x5a)])&&_0x5f214c[_0x58875a(-0x3,0x34)](_0x942dff[_0x58875a(0x4c,0x8e)],_0x19aefc[_0x58875a(-0x33,0x53)](_0x5c87fd[_0x58875a(0x23,-0x63)](_0x942dff[_0x58875a(-0x48,-0x88)](_0x942dff[_0x58875a(-0x3f,0x28)](_0x193b2d[_0x58875a(-0x14,-0x7c)](),_0x942dff[_0x58875a(-0x21,-0x12)](_0x942dff[_0x58875a(-0x42,-0x8f)](0x7a,0x61),0x1)),0x61)))+_0x99c507['random']()[_0x58875a(-0x23,0x74)](0x24)[_0x58875a(-0x61,0x28)](-0x7)):isDOMInvaderEnabled=_0x486a45[_0x58875a(0x34,0x75)]['newValue']),_0x486a45&&_0x942dff[_0x58875a(0x89,0xb3)](typeof _0x486a45[_0x58875a(-0x69,-0x96)],_0x942dff[_0x58875a(-0x8a,0x1f)])&&(isPrototypePollutionEnabled=_0x486a45[_0x58875a(-0x69,-0xec)][_0x58875a(0xb9,0x12)]);});let augmentedDomMessageContainer={'history':Object[a0_0x4d8ed7(0x11f,0x163)](null),'cache':Object[a0_0x4d8ed7(0x14d,0x163)](null),'ports':Object['create'](null),'queue':Object[a0_0x4d8ed7(0x1a0,0x163)](null),'priorityQueue':Object[a0_0x4d8ed7(0x142,0x163)](null),'badges':Object[a0_0x4d8ed7(0x11c,0x163)](null),'badgeUpdateTimers':Object[a0_0x4d8ed7(0x1ae,0x163)](null),'uniqueSinks':Object[a0_0x4d8ed7(0xf0,0x163)](null)},postMessageContainer={'history':Object[a0_0x4d8ed7(0x18a,0x163)](null),'cache':Object[a0_0x4d8ed7(0x1d7,0x163)](null),'ports':Object[a0_0x4d8ed7(0x1fa,0x163)](null),'queue':Object[a0_0x4d8ed7(0xba,0x163)](null),'priorityQueue':Object[a0_0x4d8ed7(0x209,0x163)](null),'badges':Object['create'](null),'badgeUpdateTimers':Object['create'](null),'uniqueMessages':Object[a0_0x4d8ed7(0xfe,0x163)](null)},connections=Object[a0_0x4d8ed7(0x1b1,0x163)](null),panelContainers=[augmentedDomMessageContainer,postMessageContainer];setTimeout(pollMessageQueues,POLL_TIME_MS);function pollMessageQueues(){const _0x329d78={'tyUNa':function(_0x1c3b44,_0x26780a,_0x5d7402){return _0x1c3b44(_0x26780a,_0x5d7402);},'gWRVc':function(_0x32b9df,_0x2dd634,_0x3a054c,_0x17a5b5,_0x2821b9){return _0x32b9df(_0x2dd634,_0x3a054c,_0x17a5b5,_0x2821b9);},'BJeWe':function(_0x2f3768,_0xc93db9,_0x30d077,_0x163b51){return _0x2f3768(_0xc93db9,_0x30d077,_0x163b51);},'SEMEH':_0x4a47c0(0x599,0x616),'DzRZE':function(_0x5b53ba,_0x2af426){return _0x5b53ba+_0x2af426;},'cmloa':function(_0xce36b0,_0x118b8e){return _0xce36b0+_0x118b8e;},'nFEpf':function(_0x731049,_0x27e323){return _0x731049-_0x27e323;},'BwyTU':function(_0x2ed9d4,_0x54adc4){return _0x2ed9d4===_0x54adc4;},'ROsPo':'XTfPx','wLaQj':_0x4a47c0(0x531,0x518),'LSWwN':function(_0x3f961c,_0x498b64){return _0x3f961c===_0x498b64;},'XKNPq':_0x4a47c0(0x580,0x5ff),'zaDar':function(_0x2557a0,_0x80b37a){return _0x2557a0===_0x80b37a;},'Osttk':function(_0x24d918,_0x595480,_0x35a0da,_0x3c6ede){return _0x24d918(_0x595480,_0x35a0da,_0x3c6ede);},'Jonkx':function(_0x3667f8,_0x3fe4fc){return _0x3667f8===_0x3fe4fc;},'GsMKy':_0x4a47c0(0x523,0x531),'RBNXh':function(_0x2dbb58,_0x5ecf5c,_0x37a9fd,_0x189e58){return _0x2dbb58(_0x5ecf5c,_0x37a9fd,_0x189e58);},'DMnuP':_0x4a47c0(0x4f0,0x4c7),'ocPpE':function(_0x570530,_0x3d9124,_0x154665,_0x3ad5de){return _0x570530(_0x3d9124,_0x154665,_0x3ad5de);},'TjbRC':function(_0xbbb9a6,_0x3dff67,_0x307c87,_0x20ad91){return _0xbbb9a6(_0x3dff67,_0x307c87,_0x20ad91);},'NBnnm':function(_0xd1577c,_0x5f3260,_0x35a865,_0x5dd4f9){return _0xd1577c(_0x5f3260,_0x35a865,_0x5dd4f9);},'Pugud':function(_0x47bbcf,_0x3ebb4e){return _0x47bbcf(_0x3ebb4e);}};for(let _0x4d0d27 of panelContainers){if(_0x329d78['BwyTU'](_0x329d78[_0x4a47c0(0x456,0x3c4)],_0x329d78['wLaQj'])){if(_0x47f6c5[_0x2ff6b8])for(let _0x252ff8 of _0x21a2c2[_0x3609f1]){_0x252ff8[_0x4a47c0(0x45b,0x4ed)]();}for(let _0x26537c of _0x482451){_0x329d78[_0x4a47c0(0x501,0x470)](_0x3f0676,_0x55876e,_0x26537c[_0x4a47c0(0x49d,0x47e)]),_0x329d78['tyUNa'](_0x3e40a4,_0x5c6bc7,_0x26537c[_0x4a47c0(0x503,0x46c)]),_0x37abb2(_0x183427,_0x26537c[_0x4a47c0(0x4a4,0x498)]),_0x329d78['tyUNa'](_0xf91fa7,_0xe5a94e,_0x26537c[_0x4a47c0(0x463,0x488)]);}_0x77587e(_0x146d61);}else{for(let _0x2b16df of[_0x4d0d27[_0x4a47c0(0x4a4,0x4be)],_0x4d0d27[_0x4a47c0(0x463,0x459)]]){for(const [_0x23baed,_0x25eb2a]of Object[_0x4a47c0(0x4bf,0x4ba)](_0x2b16df)){if(_0x25eb2a[_0x4a47c0(0x520,0x529)]){if(_0x329d78[_0x4a47c0(0x4ad,0x51a)](_0x329d78[_0x4a47c0(0x4c1,0x495)],_0x4a47c0(0x58f,0x5e1)))for(let _0x100f64 of _0x284b04){_0x329d78[_0x4a47c0(0x45c,0x403)](_0x3e8e88,+_0x1eb228,_0x100f64[_0x4a47c0(0x44a,0x477)],_0x5d6dab,!!_0x100f64[_0x4a47c0(0x4b7,0x566)]),!_0x2448ba[_0x4a47c0(0x441,0x46b)][_0x415a38]&&!_0x44fb18['badgeUpdateTimers'][_0x273bba]&&(_0x329d78['BJeWe'](_0x536829,_0x806d4e,_0x3b3177,+_0x380107),_0x56eca9[_0x4a47c0(0x441,0x474)][_0x2f2a78]=!![]);}else{let _0x359cd0=_0x25eb2a['splice'](0x0,MAX_QUEUE_CHUNKS);if(_0x329d78['zaDar'](augmentedDomMessageContainer,_0x4d0d27))for(let _0x57979f of _0x359cd0){_0x329d78[_0x4a47c0(0x45c,0x4bf)](updateBadgeCounters,+_0x23baed,_0x57979f[_0x4a47c0(0x4ab,0x515)],_0x4d0d27,!!_0x57979f[_0x4a47c0(0x4b7,0x4e1)]),!augmentedDomMessageContainer[_0x4a47c0(0x441,0x42e)][_0x23baed]&&!postMessageContainer[_0x4a47c0(0x441,0x3a7)][_0x23baed]&&(_0x329d78[_0x4a47c0(0x4e6,0x4db)](setTimeout,badgeUpdate,BADGE_UPDATE_TIME_MS,+_0x23baed),_0x4d0d27[_0x4a47c0(0x441,0x3db)][_0x23baed]=!![]);}else{if(_0x329d78[_0x4a47c0(0x4d3,0x51f)](postMessageContainer,_0x4d0d27))for(let _0x18d644 of _0x359cd0){_0x329d78['BwyTU'](_0x329d78[_0x4a47c0(0x451,0x4ec)],_0x329d78[_0x4a47c0(0x451,0x3ef)])?(updateBadgeCounters(+_0x23baed,_0x18d644[_0x4a47c0(0x44a,0x48a)],_0x4d0d27,!!_0x18d644[_0x4a47c0(0x4b7,0x429)]),!augmentedDomMessageContainer[_0x4a47c0(0x441,0x397)][_0x23baed]&&!postMessageContainer['badgeUpdateTimers'][_0x23baed]&&(_0x329d78['RBNXh'](setTimeout,badgeUpdate,BADGE_UPDATE_TIME_MS,+_0x23baed),_0x4d0d27[_0x4a47c0(0x441,0x4ec)][_0x23baed]=!![])):_0x5871b3[_0x4a47c0(0x4d6,0x584)](_0x329d78['SEMEH'],_0x329d78[_0x4a47c0(0x46e,0x4b4)](_0x34deb0[_0x4a47c0(0x4a6,0x424)](_0x563754[_0x4a47c0(0x4fc,0x49f)](_0x329d78['DzRZE'](_0x593047[_0x4a47c0(0x4c5,0x444)]()*_0x329d78[_0x4a47c0(0x598,0x580)](_0x329d78[_0x4a47c0(0x4c4,0x48e)](0x7a,0x61),0x1),0x61))),_0x54a452[_0x4a47c0(0x4c5,0x503)]()[_0x4a47c0(0x4b6,0x49b)](0x24)[_0x4a47c0(0x478,0x441)](-0x7)));}}let _0xc588fb={'messageType':_0x329d78[_0x4a47c0(0x51d,0x4c0)],'messageCache':_0x359cd0};!_0x329d78[_0x4a47c0(0x4df,0x4ff)](postMessageOverPort,_0x23baed,_0xc588fb,_0x4d0d27[_0x4a47c0(0x4ea,0x587)])&&_0x329d78['TjbRC'](mergeWithArray,_0x23baed,_0x359cd0,_0x4d0d27[_0x4a47c0(0x49d,0x473)]),_0x329d78[_0x4a47c0(0x4cc,0x549)](mergeWithArray,_0x23baed,_0x359cd0,_0x4d0d27[_0x4a47c0(0x503,0x52a)]);}}}}_0x329d78['Pugud'](clampAllArraysForContainer,_0x4d0d27);}}function _0x4a47c0(_0xb69ec5,_0x36df2b){return a0_0x4d8ed7(_0x36df2b,_0xb69ec5-0x336);}_0x329d78['tyUNa'](setTimeout,pollMessageQueues,POLL_TIME_MS);}function clampQueue(_0x2f7642){const _0x4be23c={'vDdbj':function(_0x18aa22,_0x1b798d){return _0x18aa22>_0x1b798d;}};let _0x60ee7b=_0x2f7642[_0x1d3fff(0x4a0,0x4ad)]-MAX_QUEUE_SIZE;function _0x1d3fff(_0x84f051,_0x1472f0){return a0_0x4d8ed7(_0x84f051,_0x1472f0-0x2c3);}_0x4be23c[_0x1d3fff(0x425,0x420)](_0x60ee7b,0x0)&&_0x2f7642[_0x1d3fff(0x398,0x3fa)](0x0,_0x60ee7b);}function a0_0x4d8ed7(_0x4decbe,_0x1994a3){return a0_0x243b(_0x1994a3- -0x79,_0x4decbe);}function clampAllArraysForContainer(_0x4fb165){function _0x3ee07c(_0x10902f,_0x329ca0){return a0_0x4d8ed7(_0x10902f,_0x329ca0-0x102);}const _0x3f9615={'eJnbN':function(_0xd15fb9,_0x1bec48,_0x8b773e){return _0xd15fb9(_0x1bec48,_0x8b773e);},'ltwyi':_0x3ee07c(0x397,0x2ff),'hgDpU':function(_0x39e577,_0x3e210a){return _0x39e577(_0x3e210a);}};for(const [_0x31058e,_0x444027]of Object[_0x3ee07c(0x2a9,0x28b)](_0x4fb165)){for(const [_0x8ff55,_0x559d72]of Object['entries'](_0x444027)){_0x3f9615[_0x3ee07c(0x376,0x31b)]!==_0x3ee07c(0x250,0x28c)?Array[_0x3ee07c(0x2f5,0x31c)](_0x559d72)&&_0x3f9615[_0x3ee07c(0x2d0,0x345)](clampQueue,_0x559d72):_0x176ddb[_0x4e3da0]=_0x3f9615[_0x3ee07c(0x217,0x250)](_0x35d973,_0x4f8ec2[_0x4812f3],_0x232597);}}}function escapeRegEx(_0x559955){const _0x43344e={'AKWQb':function(_0x131700,_0x419b24){return _0x131700===_0x419b24;},'WYYGz':'content-script','EcJrv':function(_0x2aee86,_0x162741,_0x1bcf75,_0x2f89e3){return _0x2aee86(_0x162741,_0x1bcf75,_0x2f89e3);},'fptma':'FRcdH'};function _0x27f87f(_0x38e934,_0x2741e9){return a0_0x4d8ed7(_0x2741e9,_0x38e934-0x1a1);}return _0x559955[_0x27f87f(0x3ae,0x39a)](/[*+?^${}()|[\]\\.]/g,function(_0x421c49){const _0x3d8980={'WmxIR':function(_0x42d0d2,_0x4c0375){function _0x184e76(_0x259422,_0x14b657){return a0_0x243b(_0x259422-0x97,_0x14b657);}return _0x43344e[_0x184e76(0x2a9,0x318)](_0x42d0d2,_0x4c0375);},'odUnX':_0x43344e[_0x4ff421(0x1cf,0x157)],'uUXoT':function(_0x5d88cc,_0x57d3a4,_0x3c0f82,_0x54515a){function _0x556432(_0x550df9,_0x2d8611){return _0x4ff421(_0x2d8611,_0x550df9- -0x27e);}return _0x43344e[_0x556432(-0x12a,-0x1c9)](_0x5d88cc,_0x57d3a4,_0x3c0f82,_0x54515a);}};function _0x4ff421(_0x21c6eb,_0xd4bfb5){return _0x27f87f(_0xd4bfb5- -0x1c3,_0x21c6eb);}if(_0x4ff421(0x247,0x1d3)===_0x43344e[_0x4ff421(0x1fa,0x225)])_0x3b1a93[_0x4ff421(0x169,0x19e)]&&_0x3d8980['WmxIR'](_0x550da3['from'],_0x3d8980[_0x4ff421(0x1b9,0x21e)])&&_0x571a07&&_0x4af465[_0x4ff421(0x165,0x10d)]&&_0x32b958[_0x4ff421(0x121,0x10d)][_0x4ff421(0xc6,0x123)]&&_0x3d8980[_0x4ff421(0x20a,0x188)](_0x51fc19,_0x3b4514,_0x2e8af4,_0x1d26ff['sender'][_0x4ff421(0x14c,0x123)]['id']);else return'\x5c'+_0x421c49;});}function removeCanaryIdentifier(_0x13b1e4,_0x10e174){const _0x4102a2={'pMqZm':function(_0x30071e,_0x18cd23){return _0x30071e(_0x18cd23);},'qIPbq':function(_0x5a505e,_0x46626e){return _0x5a505e+_0x46626e;},'BAWDi':function(_0x5ac66f,_0x5b5ec7){return _0x5ac66f+_0x5b5ec7;},'cYaXf':_0x3a33ac(0x2c6,0x246)};function _0x3a33ac(_0x16395d,_0x4efe46){return a0_0x4d8ed7(_0x4efe46,_0x16395d-0xe8);}return _0x4102a2['pMqZm'](String,_0x13b1e4)[_0x3a33ac(0x317,0x308)](new RegExp(_0x4102a2['qIPbq'](_0x4102a2[_0x3a33ac(0x30b,0x323)]('(',_0x4102a2[_0x3a33ac(0x21d,0x1e9)](escapeRegEx,_0x10e174)),_0x4102a2[_0x3a33ac(0x22b,0x2bb)]),'g'),'$1');}function a0_0x3193(){const _0x248f97=['DhLvtMe','wu1VDLq','AgLZDg9YEq','zfjqqvm','vhrXCge','yxjrANu','D1v3qKm','y3b1u3a','B3jIvvu','A21wuwO','BeHWshe','uKzovxG','zw5HyMXLza','ChvZAa','DwzVBMC','mJmXndrgyujdtNO','C1HpBKW','seT0Eu8','vePjDhq','kvXKkLWT','C3rVCMfNzq','t0Lgtwu','qNPkseG','tePmCMy','sNrNBuq','thHmB3q','uLztqvu','CKXLD0O','re1UDva','qKXxsuC','wLjqBvO','BgvUz3rO','CuTZAfq','z1rVzw8','u0HqweO','EhLPtgq','ExHgD2S','wwnrCey','ihnPBMS','BMHVrgy','C0vVsLC','vMjyA2C','r3PQzMG','ug9YDcbYzwfKEq','mZvRCLr1rwW','z1jhtfO','B1Hvs3K','uKXet0e','uw55vK0','tgnyzw4','sezwy3a','AwnrwwW','C3rHy2TuCMfJzq','wgzyB3m','yu9hrxu','zu9xBKy','Dvf0t2S','Cg9ZDe1LC3nHz2u','C2v0qMfKz2vuzxH0','CgvYBwLZC2LVBNnqB2XPy3K','Cg9ZDg1LC3nHz2uUANm','suvxBvq','DLzwD3O','Dw5PCxvLtwvZC2fNzxm','v2DLAee','AhnqqMm','CMvWBgfJzq','tgflqMy','vxz5BuS','qw9yDLe','AurNBuC','zffUzLy','ls0Gre9nieLUDMfKzxi6ie1LC3nHz2uGzMfPBgvKihrVihnLBMq','ywn0Aw9U','DKXlyuK','uMLTwha','zgvJBgfYyxrPDMvozxrszxf1zxn0','B3jPz2LU','Bhr3EwK','AxnbCNjHEq','nhWYFdv8mxWWFdm','vwjKzwS','u0XsAwu','BhP5Du4','DNnsB2G','rMfPBgvKihrVihnLDcbIywnRz3jVDw5KignVBg91CG','BM56B0i','D3PfAva','qKfxrgK','BgfZDevYCM9Y','ndm5ndu4tLDzsMDM','t0TkCwq','zgvTD0i','y291BNq','igfUzca','vevnywG','i2rJmZu0nq','AuzmtMK','mtG2nuPMv1rYBW','BM9Wweq','CMvWBgfJzufSBa','ig1LC3nHz2u','cKzVDw5KihnVBwv0AgLUzYbPBNrLCMvZDgLUzY4','B25czwzVCMvoyxzPz2f0zq','qxDJDeu','CMvTB3zL','rMfPBgvKihrVihnLDcbIywrNzsb0zxH0','D2PAC0y','ugfpAuO','C2LUAW','iZzJnZu3za','sMXyDwG','tMrtwNa','CerqCwW','tM1xCxm','z2v0tgf0zxn0','wgzvvMm','B2rvBLG','s1rnvhu','AKr1DKW','AgDeCfu','DxjS','AgfZAa','s0DSrKu','zNb0Bwe','y29UDgvUDc1Zzwn1CML0Es1WB2XPy3K','DLDjzei','y3PTquS','Evf5vgG','C3vIx2zYyw1L','ugzzEwi','t3vJzeW','A0rpy2G','Dwv5sfm','ALDywgO','BMfiEgG','BwTsvgS','yLnHDwm','DgHLBG','D2vItMf2AwDHDgLVBG','suXtBgS','nZa3ndu4AK5oCvHs','q2TwA1q','re9nsu5wqurfuL9qsu5h','tfz6AKC','BMv3vMfSDwu','EKTdAKy','DunVvLK','zuHWsKC','yNjVD3nLCLjLBg9HzfjLCxvPCMvK','Ahb1Efu','y21SB2e','y2fUyxj5','zLHlzLK','y2DADvi','zxHLy3v0zvnJCMLWDa','v2fQzLO','yK9uwui','BhPZv2y','ChndsNm','BMfTzq','yMfKz2vvCgrHDgvuAw1LCNm','CMv0DxjUrgf0yq','C1PTDeW','AfHxyLC','veDTt0e','yxvNBwvUDgvKlwrVBs5QCW','AgfZ','Dw5KzwzPBMvK','qKHRtgS','BwvZC2fNzq','wLnSuNy','vxD5r3G','DgfIswq','AM1AvKy','z2X6ENC','s091A0m','r3nns3K','rhvdCKq','ChjVDg90ExbLug9SBhv0Aw9UwezYyw1Lt3b0Aw9UCW','qxvlqvm','C2v2zxjPDhK','uK9Zug8','CwfAuMW','uMniALe','B25nzxnZywDL','t3fAqvu','zgLZy29UBMvJDa','z1DsvMm','Dg9kC29U','DM5Wtem','C0Ppv0m','rgDcDu0','z3DHAve','sgjushe','CxvLDwu','sgDLvMe','C2vUzgvY','wNLQuxa','mZeYmti3ogjAze9ltG','vvjTB08','wgLJwNy','Bwf0y2G','Ce1XwM0','qLzAwMO','C3bSAwnL','rhPswKu','Aw5ZDgfSBa','ChjVDg90ExbLug9SBhv0Aw9U','rurLEey','sK5VBeO','D1LTwgW','C0vOuKW','tvb0vgW','AKrzz0O','CwjKEMS','C2XPy2u','y1LHwgy','CNz5BNu','DgfI','cLrOzxjLigfYzsbZB21LigLUDgvYzxn0Aw5Nig1LC3nHz2vZlG','ChjVDg90ExbLug9SBhv0Aw9Uq1nq','z1HitMK','rePkvNy','nJG1mMXxvgjqAq','wNzbq2C','EKDpzfm','D3vPAge','zuPUyK4','zg9TlwLUDMfKzxiTC2vYDMLJzs13B3jRzxiUANm','BfDzq1y','Bg9HzfnLDhrPBMDZrNjVBujYB3DZzxi','B25jBNn0ywXSzwq','txPUA3m','B25dB25Uzwn0','rNznr1a','CMvHC29U','y2HHCKnVzgvbDa','Bg9bzu8','BwvZC2fNzvr5Cgu','rxLbv3G','D1DTsw4','yMfKz2vZ','DKrKyMO','DgvZDa','u3bbufa','vKvrrwu','whvzC3u','B25eAxnJB25Uzwn0','y3jLyxrL','zwvQC2m','A3vIywK','DgfICW','y2fJAgu','uu1Mrwy','D2fYBG','qLHQA1q','C2v0qMfKz2vcywnRz3jVDw5Kq29SB3i','quzfD1m','ywHSANu','ChjPB3jPDhLrDwv1zq','ywrKtgLZDgvUzxi','zNjVBunOyxjdB2rL','y0TtB3a','EvvnA1a','yNb1tNC','BhDjwg8','DhjHy2u','rwnkCNy','tfnxD04','DwPHqw0','v1Lzr3O','A2zry1K','Aw50zxjLC3rPBMC','sgXXz3q','z2v0u2v0DgLUzW','CMv0DxjUug9ZDg1LC3nHz2veyxrH','uwLMzwm','Dg9tDhjPBMC','ChjPB3jPDhK','wNLRtgO','Bg9N','BePRtwq','vwzXvNq','CMvZzxq','vKjgBKC','mJG3nJe2nNDlzxPLzG','zw50CMLLCW','t0rdEKG','weTouhe','mtm0mgnlExD1Ca','qNvWD2e','BKzfCgy','CMfUzg9T','B25dAgfUz2vK','BKPptKu','rMfPBgvKihrVihnLDcb0AxrSzq','C2v0vgL0Bgu','AeHYCKq','thH5ChK','tKjUBM0','CNvUDgLTzq','C291CMnL','quTxuwi','s2rcwMu','DxbKyxrLrhLUyw1Py1j1BgvZ','zNjHBwvjza','sM9UA3G','q0r5yvy','wKPsvNG','C2v0u2v0DgLUzW','y2XLyxjnzxnZywDLCW','Dw5PCxvLu2LUA3m','AM9AExy','y29UzMLKzw5Jzq','BwfPBL9MCMfTzq','rvrVthO','C0jWsuO','ufDHrhO','B2nqCeu','DvvyB1q','CxHoB3y','mZKXmZH3r0LesNC','r1ziwxq','EwPJB1a','txvfrwm','t3n0DgS','tufjtG','y29SBgvJDfbVC3rTzxnZywDL','CgvYBwLZC2LVBNmTCg9SAwn5','Cg9YDhm','DMfSDwu','y21ICgO','serSq2G','B25szw1VDMvK','ywrK','zgf0yufYCMf5','C2nYAxb0Aw5N','Bw9KAwz5sgvHzgvYCW','zwnXt3u','z25Rrxa','uNvSzxmGDxbKyxrLza','zNjVBq','B25szxbSywnLza','ruXIANm','rMDPvMm','zKHRAgi','C3bSAxq','zMXVB3i','EwjstK4','mvPRzxH1za','v3LcrLK','m3W1Fdf8mNW0Fda'];a0_0x3193=function(){return _0x248f97;};return a0_0x3193();}function hashCode(_0x45c739){const _0x2d23f8={'IEWmT':function(_0x3eaaf4,_0x3c641e,_0x33b754){return _0x3eaaf4(_0x3c641e,_0x33b754);},'jmZVF':function(_0x3ec659,_0x55ac74){return _0x3ec659===_0x55ac74;},'yUMkP':_0x1f974b(0x57e,0x57f),'fHkhb':function(_0x43b270,_0x561a36){return _0x43b270(_0x561a36);},'hHrrD':function(_0x3fd8a9,_0x423319){return _0x3fd8a9+_0x423319;},'arQju':function(_0x394e6c,_0x2ac41e){return _0x394e6c<_0x2ac41e;},'SLRie':function(_0x4b8866,_0x1dd262){return _0x4b8866!==_0x1dd262;},'qaZRl':_0x1f974b(0x62a,0x5bf),'ecqOu':function(_0x38ce67,_0x246451){return _0x38ce67|_0x246451;},'uCoVY':function(_0x57ef4d,_0x2132a4){return _0x57ef4d+_0x2132a4;}};_0x45c739=_0x2d23f8[_0x1f974b(0x571,0x619)](_0x45c739,'');let _0x520046=0x0;function _0x1f974b(_0x2a5d1d,_0xbf5575){return a0_0x4d8ed7(_0xbf5575,_0x2a5d1d-0x3dd);}let _0x16c6fa=_0x45c739['length'];for(let _0x48f4c0=0x0;_0x2d23f8[_0x1f974b(0x5ad,0x63f)](_0x48f4c0,_0x16c6fa);++_0x48f4c0){_0x2d23f8[_0x1f974b(0x5fa,0x684)](_0x2d23f8[_0x1f974b(0x4fe,0x4da)],_0x2d23f8['qaZRl'])?(_0xae1662[_0x1f974b(0x591,0x634)][_0x10d469]=_0x49745a,_0x115ce2[_0x1f974b(0x53f,0x4a5)][_0x1f974b(0x54c,0x541)](()=>{function _0x20be4c(_0x438651,_0x4cd3c1){return _0x1f974b(_0x438651- -0x665,_0x4cd3c1);}_0x300f68['cache'][_0x481f7e]=_0x2d23f8[_0x20be4c(-0x80,-0xc4)](_0xef4484,_0x35a500[_0x20be4c(-0x121,-0xac)][_0xfa4f1a],_0xb0c093[_0x20be4c(-0xbb,-0x1d)][_0x58694e]);}),_0x25c176['onMessage'][_0x1f974b(0x54c,0x4c5)]((_0x4971e9,_0x144c13,_0x306226)=>{function _0xcd0a08(_0x4f4227,_0x173dce){return _0x1f974b(_0x173dce- -0x590,_0x4f4227);}_0x2d23f8[_0xcd0a08(-0x18,-0x9b)](_0x4971e9[_0xcd0a08(-0x9d,-0x5a)],_0x2d23f8[_0xcd0a08(-0x5a,-0x41)])&&(_0x53f5dc(_0x4a6ceb,_0x57ad4f[_0xcd0a08(0x61,-0x4c)]),_0x2d23f8[_0xcd0a08(0x60,0x55)](_0x576e25,_0xa8f240,_0x4b0648[_0xcd0a08(0x42,0x1a)]),_0x2d23f8[_0xcd0a08(0x39,0x11)](_0xb6dab2,_0xc1bde2));})):_0x520046=_0x2d23f8[_0x1f974b(0x59a,0x547)](_0x2d23f8[_0x1f974b(0x63b,0x6aa)](Math['imul'](0x1f,_0x520046),_0x45c739[_0x1f974b(0x534,0x4d8)](_0x48f4c0)),0x0);}return _0x520046;}function resetBadge(_0xcb15f2){const _0x666e7={'MuEEc':function(_0x2ae5d4,_0x104501){return _0x2ae5d4-_0x104501;},'sBpIJ':function(_0x11fed8,_0x325700){return _0x11fed8>_0x325700;},'dQnfV':function(_0x5ed808,_0x41fa14){return _0x5ed808!==_0x41fa14;},'UfqVt':_0x363b3f(0x2bf,0x332),'GVHYt':_0x363b3f(0x2b9,0x2a6),'Qifec':_0x363b3f(0x2e1,0x25e),'DUMLI':'Failed\x20to\x20set\x20title'};delete augmentedDomMessageContainer[_0x363b3f(0x1e0,0x170)][_0xcb15f2],delete augmentedDomMessageContainer[_0x363b3f(0x226,0x2c0)][_0xcb15f2],delete augmentedDomMessageContainer['badgeUpdateTimers'][_0xcb15f2];function _0x363b3f(_0x90823a,_0x402e24){return a0_0x4d8ed7(_0x402e24,_0x90823a-0x84);}delete postMessageContainer['badges'][_0xcb15f2],delete postMessageContainer[_0x363b3f(0x28e,0x291)][_0xcb15f2],delete postMessageContainer['badgeUpdateTimers'][_0xcb15f2],chrome[_0x363b3f(0x298,0x2b7)][_0x363b3f(0x1ef,0x290)]({'tabId':_0xcb15f2,'color':_0x363b3f(0x2bd,0x274)},()=>{function _0x88758(_0x27a3f1,_0x52ad9a){return _0x363b3f(_0x27a3f1-0x26a,_0x52ad9a);}chrome['runtime'][_0x88758(0x512,0x564)]&&console[_0x88758(0x471,0x4e8)](_0x88758(0x50e,0x53d),chrome[_0x88758(0x485,0x517)][_0x88758(0x512,0x4bd)]);}),chrome[_0x363b3f(0x298,0x323)][_0x363b3f(0x289,0x2ff)]({'tabId':_0xcb15f2,'text':''},()=>{function _0x429243(_0x45ed0a,_0x9c0693){return _0x363b3f(_0x45ed0a- -0x91,_0x9c0693);}if(chrome[_0x429243(0x18a,0x157)][_0x429243(0x217,0x197)]){if(_0x666e7[_0x429243(0x205,0x1a7)](_0x666e7[_0x429243(0x178,0xec)],_0x429243(0x22e,0x214))){let _0x162468=_0x666e7[_0x429243(0x1a2,0x10d)](_0x5bd100[_0x429243(0x1dd,0x226)],_0x37811a);_0x666e7[_0x429243(0x19a,0x189)](_0x162468,0x0)&&_0x4ce37e[_0x429243(0x12a,0xdb)](0x0,_0x162468);}else console[_0x429243(0x176,0x19f)](_0x666e7[_0x429243(0x1a0,0x11c)],chrome[_0x429243(0x18a,0x1db)][_0x429243(0x217,0x1d9)]);}}),chrome[_0x363b3f(0x298,0x20f)][_0x363b3f(0x217,0x1fb)]({'tabId':_0xcb15f2,'title':''},()=>{function _0x16656c(_0x32e132,_0x3886be){return _0x363b3f(_0x3886be- -0x233,_0x32e132);}chrome[_0x16656c(-0x8e,-0x18)][_0x16656c(0x60,0x75)]&&(_0x666e7[_0x16656c(0x28,-0x30)]!==_0x16656c(-0x10e,-0x8b)?console['log'](_0x666e7['DUMLI'],chrome[_0x16656c(-0x2d,-0x18)][_0x16656c(0xa9,0x75)]):_0xb9cc36=_0x459d78[_0x16656c(-0xeb,-0x75)]['newValue']);});}function badgeUpdate(_0x184e1d){const _0x196fd2={'vWIdB':_0x1ed53f(0x150,0x1ae),'kfQcY':'--\x20DOM\x20Invader:\x20Message\x20failed\x20to\x20send','BGRmT':function(_0x2730a1,_0x43bdf3){return _0x2730a1!==_0x43bdf3;},'hsPBc':'bEgfa','KGlFE':_0x1ed53f(0x1f4,0x1b5),'VBFnG':_0x1ed53f(0x61,0xba),'nnzoB':_0x1ed53f(0x19d,0x1c3),'HKtyO':'Failed\x20to\x20set\x20title','ZAWcU':_0x1ed53f(0x1aa,0x1c7),'sndiP':function(_0x5011fc,_0xa0255c){return _0x5011fc(_0xa0255c);}};let _0x1784d5=0x0,_0x37be33=![],_0x1db96e=0x0,_0x3cd61a=0x0;augmentedDomMessageContainer[_0x1ed53f(0x47,0xea)][_0x184e1d]&&(_0x1784d5+=augmentedDomMessageContainer[_0x1ed53f(0x106,0xea)][_0x184e1d][_0x1ed53f(0x121,0x1b6)],_0x1db96e=augmentedDomMessageContainer['badges'][_0x184e1d]['count'],augmentedDomMessageContainer[_0x1ed53f(0x5c,0xea)][_0x184e1d][_0x1ed53f(0x150,0x109)]&&(_0x37be33=!![]),delete augmentedDomMessageContainer[_0x1ed53f(0xeb,0x99)][_0x184e1d]);postMessageContainer[_0x1ed53f(0x16b,0xea)][_0x184e1d]&&(_0x1784d5+=postMessageContainer[_0x1ed53f(0x151,0xea)][_0x184e1d][_0x1ed53f(0x1b4,0x1b6)],_0x3cd61a=postMessageContainer[_0x1ed53f(0xdf,0xea)][_0x184e1d][_0x1ed53f(0x153,0x1b6)],postMessageContainer[_0x1ed53f(0xb4,0xea)][_0x184e1d][_0x1ed53f(0x166,0x109)]&&(_0x37be33=!![]),delete postMessageContainer['badgeUpdateTimers'][_0x184e1d]);function _0x1ed53f(_0xb591b6,_0x49c5d0){return a0_0x4d8ed7(_0xb591b6,_0x49c5d0- -0x72);}_0x37be33?chrome[_0x1ed53f(0x1f7,0x1a2)]['setBadgeBackgroundColor']({'tabId':_0x184e1d,'color':_0x1ed53f(0x221,0x1b9)},()=>{function _0x230838(_0x435529,_0xa52e78){return _0x1ed53f(_0xa52e78,_0x435529- -0xb4);}chrome['runtime'][_0x230838(0xfe,0x112)]&&console['log'](_0x196fd2[_0x230838(0x123,0x117)],chrome[_0x230838(0x71,0xaf)][_0x230838(0xfe,0x69)]);}):chrome['action'][_0x1ed53f(0x1a5,0xf9)]({'tabId':_0x184e1d,'color':_0x196fd2['ZAWcU']},()=>{function _0x31eead(_0x52cdc0,_0x230e48){return _0x1ed53f(_0x230e48,_0x52cdc0-0xa0);}if(chrome[_0x31eead(0x1c5,0x114)]['lastError']){if(_0x196fd2['BGRmT'](_0x196fd2[_0x31eead(0x23a,0x226)],_0x196fd2[_0x31eead(0x274,0x288)]))console['log'](_0x196fd2[_0x31eead(0x277,0x24e)],chrome[_0x31eead(0x1c5,0x1fb)][_0x31eead(0x252,0x206)]);else try{return _0x272958[_0x18e2f5][_0x31eead(0x232,0x193)](_0x4fbd7f),!![];}catch(_0x30415e){_0x4d7a7e['warn'](_0x196fd2[_0x31eead(0x1a8,0x1b1)]);}}});chrome[_0x1ed53f(0x199,0x1a2)][_0x1ed53f(0x190,0x193)]({'tabId':_0x184e1d,'text':_0x196fd2['sndiP'](String,_0x1784d5)},()=>{function _0x5d37e7(_0x556db3,_0x2890f3){return _0x1ed53f(_0x2890f3,_0x556db3-0x29d);}_0x5d37e7(0x357,0x3f7)!==_0x196fd2[_0x5d37e7(0x3b2,0x445)]?_0x8c8f51=_0x2eff3f['permissionsPolicy'][_0x5d37e7(0x487,0x484)]:chrome['runtime'][_0x5d37e7(0x44f,0x4a5)]&&console['log'](_0x196fd2[_0x5d37e7(0x44c,0x434)],chrome[_0x5d37e7(0x3c2,0x455)][_0x5d37e7(0x44f,0x413)]);});let _0x50612a='Found\x20'+_0x1db96e+_0x1ed53f(0xd4,0x17f)+(_0x1db96e===0x1?'':'s')+_0x1ed53f(0x165,0x1b7)+_0x3cd61a+_0x1ed53f(0x194,0x1be)+(_0x3cd61a===0x1?'':'s')+'.';augmentedDomMessageContainer[_0x1ed53f(0x58,0xea)][_0x184e1d]?.['interesting']&&(_0x1db96e>0x0?_0x50612a+='\x0aThere\x20are\x20some\x20interesting\x20sinks.':_0x50612a+=_0x1ed53f(0x21a,0x1bf)),postMessageContainer['badges'][_0x184e1d]?.['interesting']&&(_0x50612a+=_0x1ed53f(0x4d,0xd4)),chrome[_0x1ed53f(0x19c,0x1a2)]['setTitle']({'tabId':_0x184e1d,'title':_0x50612a},()=>{function _0x46de56(_0x578171,_0x815b14){return _0x1ed53f(_0x578171,_0x815b14- -0x24b);}chrome[_0x46de56(-0x195,-0x126)]['lastError']&&console['log'](_0x196fd2[_0x46de56(-0x83,-0xe1)],chrome[_0x46de56(-0x126,-0x126)][_0x46de56(-0x39,-0x99)]);});}function updateBadgeCounters(_0x25dd4e,_0x235759,_0x57213a,_0x2fb53c){const _0x573dd5={'ojOeT':_0x1067f8(0x4b7,0x515),'gToeo':function(_0x4f1642,_0x808f82,_0x31ccdd,_0x5bfeef){return _0x4f1642(_0x808f82,_0x31ccdd,_0x5bfeef);},'wuiha':_0x1067f8(0x408,0x46b),'eOWnF':function(_0x5cfdd0,_0x1614ee){return _0x5cfdd0===_0x1614ee;},'Zvyku':_0x1067f8(0x42a,0x449),'EDexF':_0x1067f8(0x472,0x417),'zGOdS':function(_0x2a8c3f,_0x3131c0){return _0x2a8c3f(_0x3131c0);},'vsRoh':function(_0x26e7ff,_0xe19a79,_0x418031){return _0x26e7ff(_0xe19a79,_0x418031);},'FgiVc':function(_0x2ba346,_0xf4cb7e){return _0x2ba346!==_0xf4cb7e;},'psCJs':_0x1067f8(0x4c4,0x414),'LxLot':function(_0x2de30d,_0x432256){return _0x2de30d===_0x432256;},'ZJRVx':'SOThS','orbUU':_0x1067f8(0x3ca,0x446),'LWkmu':_0x1067f8(0x4ac,0x4a2),'hXWbW':_0x1067f8(0x3cb,0x375),'NScMb':function(_0x457fcc,_0x161058){return _0x457fcc(_0x161058);},'WajfZ':function(_0x2e70c1,_0x127131){return _0x2e70c1+_0x127131;},'PaOiJ':function(_0x2be0c4,_0x978713){return _0x2be0c4+_0x978713;},'HgeVa':function(_0x51bdb6,_0x1a010b){return _0x51bdb6+_0x1a010b;},'MPtTl':function(_0x2b194b,_0x3a2040){return _0x2b194b+_0x3a2040;},'lHpHq':function(_0x383c51,_0x34ec6e,_0x356465){return _0x383c51(_0x34ec6e,_0x356465);}};function _0x1067f8(_0xdcfafa,_0x39f25b){return a0_0x4d8ed7(_0x39f25b,_0xdcfafa-0x282);}!augmentedDomMessageContainer[_0x1067f8(0x3de,0x3af)][_0x25dd4e]&&(augmentedDomMessageContainer[_0x1067f8(0x3de,0x396)][_0x25dd4e]={'count':0x0,'interesting':![]});!augmentedDomMessageContainer[_0x1067f8(0x424,0x480)][_0x25dd4e]&&(augmentedDomMessageContainer[_0x1067f8(0x424,0x495)][_0x25dd4e]=new Set());!postMessageContainer[_0x1067f8(0x3de,0x36b)][_0x25dd4e]&&(postMessageContainer[_0x1067f8(0x3de,0x443)][_0x25dd4e]={'count':0x0,'interesting':![]});!postMessageContainer[_0x1067f8(0x48c,0x490)][_0x25dd4e]&&(postMessageContainer[_0x1067f8(0x48c,0x445)][_0x25dd4e]=new Set());if(_0x573dd5[_0x1067f8(0x484,0x41c)](augmentedDomMessageContainer,_0x57213a)){if(_0x573dd5[_0x1067f8(0x484,0x52c)](_0x573dd5['Zvyku'],_0x573dd5[_0x1067f8(0x3bd,0x3b2)]))_0xfee86d['runtime'][_0x1067f8(0x4a6,0x53b)]&&_0x6c0736[_0x1067f8(0x405,0x3ea)](_0x573dd5['ojOeT'],_0x4bcf00[_0x1067f8(0x419,0x372)][_0x1067f8(0x4a6,0x4a0)]);else for(let _0x189b63 of _0x235759){_0x189b63[_0x1067f8(0x4c7,0x4a4)]=_0x573dd5[_0x1067f8(0x3ce,0x46b)](hashCode,(_0x189b63[_0x1067f8(0x4ba,0x49c)]?_0x189b63[_0x1067f8(0x4ba,0x47f)]:_0x189b63[_0x1067f8(0x41a,0x48e)])+_0x573dd5[_0x1067f8(0x4a1,0x4ec)](removeCanaryIdentifier,_0x189b63[_0x1067f8(0x437,0x404)],canary)+''+_0x189b63['stackTrace']);_0x2fb53c&&(_0x573dd5[_0x1067f8(0x445,0x39f)](_0x1067f8(0x492,0x44d),_0x573dd5[_0x1067f8(0x38b,0x3e3)])?augmentedDomMessageContainer[_0x1067f8(0x3de,0x3e6)][_0x25dd4e]['interesting']=!![]:_0x40f966+=_0x1067f8(0x3c8,0x422));if(!_0x189b63[_0x1067f8(0x4ba,0x55d)]){if(_0x573dd5[_0x1067f8(0x466,0x3b8)](_0x573dd5[_0x1067f8(0x421,0x3a8)],_0x573dd5[_0x1067f8(0x455,0x4a8)])){let _0x1948e3=_0x1fe36b[_0x1067f8(0x3c7,0x3fc)]['id'];for(let _0x44b406 of _0x4e7cbb){_0x573dd5[_0x1067f8(0x46e,0x3cc)](_0x4c47e8,_0x1948e3,{'messageType':_0x573dd5[_0x1067f8(0x3cf,0x47a)]},_0x44b406['ports']);}}else continue;}!augmentedDomMessageContainer['uniqueSinks'][_0x25dd4e]['has'](_0x189b63['sink'])&&(augmentedDomMessageContainer['badges'][_0x25dd4e][_0x1067f8(0x4aa,0x433)]++,augmentedDomMessageContainer[_0x1067f8(0x424,0x383)][_0x25dd4e][_0x1067f8(0x43b,0x3fa)](_0x189b63[_0x1067f8(0x4ba,0x51e)]));}}else{if(postMessageContainer===_0x57213a){if(_0x573dd5['LWkmu']===_0x573dd5[_0x1067f8(0x390,0x38c)]){let _0x3ab8e0=_0x3aa9dd[_0x1067f8(0x403,0x395)]?_0x154be9['priorityQueue']:_0x4d611f[_0x1067f8(0x3af,0x3cb)];!_0x3ab8e0[_0x298252]&&(_0x3ab8e0[_0x399132]=[]),_0x3ab8e0[_0x1a70c8][_0x1067f8(0x45a,0x494)](_0x3fd024);}else _0x235759[_0x1067f8(0x4c7,0x443)]=_0x573dd5['NScMb'](hashCode,_0x573dd5[_0x1067f8(0x388,0x396)](_0x573dd5[_0x1067f8(0x4b9,0x543)](_0x573dd5[_0x1067f8(0x3b0,0x325)](_0x573dd5[_0x1067f8(0x3c1,0x3a0)](_0x573dd5[_0x1067f8(0x4b9,0x512)]('',_0x573dd5[_0x1067f8(0x457,0x447)](removeCanaryIdentifier,_0x235759['manipulatedData'],canary)),_0x235759[_0x1067f8(0x481,0x4ca)]),_0x235759[_0x1067f8(0x49a,0x4fa)]),_0x235759['id']===0x0)+_0x235759[_0x1067f8(0x3a1,0x429)],_0x235759[_0x1067f8(0x426,0x37f)])),_0x2fb53c&&(postMessageContainer[_0x1067f8(0x3de,0x35c)][_0x25dd4e]['interesting']=!![]),!postMessageContainer[_0x1067f8(0x48c,0x48c)][_0x25dd4e][_0x1067f8(0x393,0x41a)](_0x235759[_0x1067f8(0x4c7,0x544)])&&(postMessageContainer['badges'][_0x25dd4e]['count']++,postMessageContainer[_0x1067f8(0x48c,0x523)][_0x25dd4e][_0x1067f8(0x43b,0x45c)](_0x235759[_0x1067f8(0x4c7,0x569)]));}}}function addToQueue(_0x47fb7a,_0x161267,_0xb4959b){function _0x5d8e81(_0x17ce83,_0x4ba4e0){return a0_0x4d8ed7(_0x17ce83,_0x4ba4e0-0xd2);}const _0x24a220={'xyiLd':function(_0x44c49b,_0x1975b3,_0x1d0322,_0x18203a,_0x540015){return _0x44c49b(_0x1975b3,_0x1d0322,_0x18203a,_0x540015);},'CDyaV':function(_0xe942be,_0x522594,_0x521cf3,_0x26d637){return _0xe942be(_0x522594,_0x521cf3,_0x26d637);},'UvymK':function(_0x1af567,_0x535821){return _0x1af567===_0x535821;},'jWXXj':'YLcai'};let _0x58d88b=_0x47fb7a[_0x5d8e81(0x27f,0x253)]?_0x161267[_0x5d8e81(0x1f8,0x240)]:_0x161267[_0x5d8e81(0x196,0x1ff)];if(!_0x58d88b[_0xb4959b]){if(_0x24a220[_0x5d8e81(0x265,0x2e1)](_0x24a220[_0x5d8e81(0x386,0x323)],_0x24a220[_0x5d8e81(0x36b,0x323)]))_0x58d88b[_0xb4959b]=[];else for(let _0x403ad2 of _0xf9051a){_0x24a220[_0x5d8e81(0x36b,0x2c0)](_0x356105,+_0x4a5f0c,_0x403ad2[_0x5d8e81(0x1b6,0x247)],_0x303681,!!_0x403ad2['priority']),!_0x52fec6[_0x5d8e81(0x1d9,0x1dd)][_0x5ad30d]&&!_0x20d17e[_0x5d8e81(0x233,0x1dd)][_0x74d362]&&(_0x24a220[_0x5d8e81(0x2b6,0x270)](_0x2d9244,_0x4ae25f,_0x366af8,+_0x4a4450),_0x132e2e[_0x5d8e81(0x24b,0x1dd)][_0x17a2f9]=!![]);}}_0x58d88b[_0xb4959b][_0x5d8e81(0x309,0x2aa)](_0x47fb7a);}function postMessageOverPort(_0x54f0d2,_0x3b43e2,_0x2ef939){const _0x4710f6={'WgehA':_0x529125(0x4ed,0x568)};if(_0x54f0d2 in _0x2ef939)try{return _0x2ef939[_0x54f0d2][_0x529125(0x4de,0x533)](_0x3b43e2),!![];}catch(_0x1221c2){console[_0x529125(0x443,0x410)](_0x4710f6[_0x529125(0x4e5,0x48f)]);}function _0x529125(_0x110731,_0x336305){return a0_0x4d8ed7(_0x336305,_0x110731-0x2da);}return![];}function mergeWithArray(_0x459062,_0x544674,_0x267ff6){const _0x201da6={'TJItt':function(_0x34a44d,_0x130549,_0x20d639){return _0x34a44d(_0x130549,_0x20d639);}};function _0x53c61c(_0x18aaa2,_0x5a5829){return a0_0x4d8ed7(_0x18aaa2,_0x5a5829- -0x6d);}_0x267ff6[_0x459062]=_0x201da6[_0x53c61c(0x1d2,0x170)](mergeArrays,_0x267ff6[_0x459062],_0x544674);}function pushToArray(_0x5a3ff2,_0xd066d4,_0x58ba1a){const _0x140ebe={'PGbui':function(_0x5e01e0,_0x5f4b91,_0x4cfcc7,_0x61a7e9){return _0x5e01e0(_0x5f4b91,_0x4cfcc7,_0x61a7e9);},'pDPql':_0x3574f6(0x1b1,0x182),'lwIXo':function(_0x579b3f,_0x39ec93,_0x3579a2){return _0x579b3f(_0x39ec93,_0x3579a2);},'icQYl':function(_0x5ea361,_0x60575,_0x24bbef){return _0x5ea361(_0x60575,_0x24bbef);},'hpuxU':function(_0x1dc572,_0x149f5a){return _0x1dc572!==_0x149f5a;}};if(!_0x58ba1a[_0x5a3ff2]){if(_0x140ebe[_0x3574f6(0x258,0x2e3)]('Fjymd',_0x3574f6(0x219,0x1a0)))_0x58ba1a[_0x5a3ff2]=[];else{let _0x118d26=_0x5b85d0[_0x3574f6(0x10e,0x154)];if(_0x231735['cache'][_0x118d26]&&!_0x5bfdc5['cache'][_0x118d26][_0x3574f6(0x1e1,0x144)])return;_0x140ebe['PGbui'](_0x390ac7,_0x118d26,{'messageType':_0x140ebe[_0x3574f6(0x233,0x2c3)],'messageCache':_0x140ebe[_0x3574f6(0x16b,0x21a)](_0x14656a,_0x7741c9[_0x3574f6(0x15e,0xe3)],_0x118d26)},_0x4deb0e[_0x3574f6(0x1ab,0x187)])&&_0x140ebe[_0x3574f6(0x1f5,0x19f)](_0x3f3ddf,_0x118d26,_0x6e5dc3[_0x3574f6(0x15e,0x110)]);}}function _0x3574f6(_0x246c5d,_0x23c302){return a0_0x4d8ed7(_0x23c302,_0x246c5d- -0x9);}_0x58ba1a[_0x5a3ff2]['push'](_0xd066d4);}function emptyMessages(_0x2d6015){function _0x2b96fe(_0x67af6d,_0x10cf78){return a0_0x4d8ed7(_0x10cf78,_0x67af6d- -0x25b);}const _0x11692={'AuKAS':function(_0x436c6e,_0x4f2573){return _0x436c6e(_0x4f2573);},'XfUVc':_0x2b96fe(-0x12b,-0x15f),'BzJHH':function(_0x325d85,_0x2c7832){return _0x325d85===_0x2c7832;},'nJONE':'yosic','kmVQj':function(_0x3f169b,_0x398847){return _0x3f169b!==_0x398847;},'FcQvq':_0x2b96fe(-0x11a,-0x117),'sJOWC':function(_0x37adf9,_0x269700,_0x530cb6){return _0x37adf9(_0x269700,_0x530cb6);},'ILSlk':function(_0x12cf17,_0x78820e){return _0x12cf17(_0x78820e);}};if(connections[_0x2d6015]){if(_0x11692[_0x2b96fe(-0x1c,0x56)]!==_0x11692[_0x2b96fe(-0x1c,-0x36)])_0x2b05b4['badges'][_0x110e21][_0x2b96fe(-0xe0,-0x44)]=!![];else for(let _0x521569 of connections[_0x2d6015]){_0x11692[_0x2b96fe(-0x7a,0x2e)]('doIHQ',_0x11692[_0x2b96fe(-0xca,-0x10e)])?_0x279eec=[]:_0x521569[_0x2b96fe(-0x136,-0x12c)]();}}for(let _0x8c3c3f of panelContainers){_0x11692[_0x2b96fe(-0x87,-0x115)](_0x11692['FcQvq'],'qbdzk')?_0x11692[_0x2b96fe(-0x13d,-0x168)](_0xd341ad,_0x5577ee):(_0x11692[_0x2b96fe(-0x132,-0xff)](emptySpecificMessageArray,_0x2d6015,_0x8c3c3f[_0x2b96fe(-0xf4,-0xf9)]),emptySpecificMessageArray(_0x2d6015,_0x8c3c3f[_0x2b96fe(-0x8e,-0xda)]),_0x11692[_0x2b96fe(-0x132,-0x97)](emptySpecificMessageArray,_0x2d6015,_0x8c3c3f['priorityQueue']),_0x11692[_0x2b96fe(-0x132,-0x16a)](emptySpecificMessageArray,_0x2d6015,_0x8c3c3f[_0x2b96fe(-0x12e,-0x191)]));}_0x11692[_0x2b96fe(-0x4,-0x39)](resetBadge,_0x2d6015);}function emptySpecificMessageArray(_0x45a09b,_0x35121d){_0x35121d[_0x45a09b]=[];}function reduceSpecificMessageCache(_0x7116f3,_0x4edf26){const _0x1b3ac8={'jDYgJ':function(_0x372100,_0x54e00b){return _0x372100===_0x54e00b;},'ELbjs':_0x2a5c7d(0x3f6,0x370)};!_0x4edf26[_0x7116f3]&&(_0x1b3ac8[_0x2a5c7d(0x303,0x261)](_0x1b3ac8['ELbjs'],_0x1b3ac8[_0x2a5c7d(0x385,0x400)])?_0x4edf26[_0x7116f3]=[]:(_0x1afd9e(_0xe36c9a,_0x5ed2e0['cache']),_0x222bb9(_0x5c2122,_0x3bafa6[_0x2a5c7d(0x390,0x2e7)]),_0x4d05fe(_0x5631ee)));function _0x2a5c7d(_0xc9e9c2,_0x16c71d){return a0_0x4d8ed7(_0x16c71d,_0xc9e9c2-0x1c3);}_0x4edf26[_0x7116f3]=_0x4edf26[_0x7116f3]['slice'](MAX_QUEUE_CHUNKS);}function takeElementsFromArray(_0x264c11,_0x121fc0){function _0x369c35(_0xa0b515,_0x54ffbc){return a0_0x4d8ed7(_0x54ffbc,_0xa0b515- -0x294);}const _0x2b20bb={'tpHZX':function(_0x3a8e0a,_0x4411f0){return _0x3a8e0a===_0x4411f0;},'KBtyl':_0x369c35(-0x187,-0x12b),'EyAWx':'lBCDk'};if(!_0x264c11[_0x121fc0]){if(_0x2b20bb['tpHZX'](_0x2b20bb['KBtyl'],_0x2b20bb[_0x369c35(-0x13a,-0x9e)]))return!_0x50f0c5&&(_0x54d33d=[]),!_0x4e7b05&&(_0x540d46=[]),[..._0x17e159,..._0x308e78];else _0x264c11[_0x121fc0]=[];}return _0x264c11[_0x121fc0][_0x369c35(-0x152,-0xb9)](0x0,MAX_QUEUE_CHUNKS);}function destroyMessageObjects(_0x22dc71){const _0x78c5c0={'OKJqd':_0x12f4b4(0x3a0,0x3f5),'JNolJ':function(_0x293666,_0x516550){return _0x293666(_0x516550);},'vVVwz':function(_0x580664,_0x17d5ec){return _0x580664===_0x17d5ec;}};_0x78c5c0[_0x12f4b4(0x282,0x311)](emptyMessages,_0x22dc71);function _0x12f4b4(_0x2fb771,_0x1ac5bd){return a0_0x4d8ed7(_0x2fb771,_0x1ac5bd-0x1d5);}for(let _0x5a3bcd of panelContainers){if(_0x78c5c0[_0x12f4b4(0x45f,0x3de)](_0x12f4b4(0x3a7,0x3ea),_0x12f4b4(0x48c,0x3ea)))for(let [_0x46f305,_0x475395]of Object['entries'](_0x5a3bcd)){_0x475395[_0x22dc71]&&delete _0x475395[_0x22dc71];}else _0x2a01f6[_0x12f4b4(0x384,0x36c)][_0x12f4b4(0x3fe,0x3f9)]&&_0x3019d2[_0x12f4b4(0x36d,0x358)](_0x78c5c0[_0x12f4b4(0x447,0x3fb)],_0x47c745[_0x12f4b4(0x3c4,0x36c)]['lastError']);}}function mergeArrays(_0x1d339c,_0x30ba52){return!_0x1d339c&&(_0x1d339c=[]),!_0x30ba52&&(_0x30ba52=[]),[..._0x1d339c,..._0x30ba52];}const tabPortRegex=/(.*):(\d+)/;chrome[a0_0x4d8ed7(0x134,0x197)][a0_0x4d8ed7(0x1d0,0x154)]['addListener'](_0x289c01=>{const _0x484983={'ufong':function(_0x57b51c,_0x3cc4ae,_0x2a36bb){return _0x57b51c(_0x3cc4ae,_0x2a36bb);},'HDlCh':function(_0x370891,_0x455305){return _0x370891===_0x455305;},'KTMTu':function(_0x28145a,_0x5d1bad){return _0x28145a!==_0x5d1bad;},'KdBZe':_0x2e2cd8(0x41f,0x47b),'sOeGB':function(_0x53db60,_0x474d4f){return _0x53db60(_0x474d4f);},'Hlqgt':function(_0x3ffff8,_0x53683e){return _0x3ffff8(_0x53683e);},'fDggV':_0x2e2cd8(0x4ab,0x488),'BLWIG':function(_0x4523ca,_0x9e86e3,_0xd76172){return _0x4523ca(_0x9e86e3,_0xd76172);},'lWYCV':function(_0x4abd15,_0xa49396,_0x174ea2,_0x4fffbb){return _0x4abd15(_0xa49396,_0x174ea2,_0x4fffbb);},'LcXen':_0x2e2cd8(0x38a,0x3b8),'YdHUA':_0x2e2cd8(0x4b0,0x40e),'iDgmG':function(_0x30e856,_0x2cd577,_0x45278f){return _0x30e856(_0x2cd577,_0x45278f);},'SQkPg':function(_0x3eba7b,_0x3203c0){return _0x3eba7b===_0x3203c0;},'uQtOk':'content-script','znUqP':'initialMessage','loAeO':_0x2e2cd8(0x3e2,0x3c2),'qKshT':function(_0x5bdc01,_0x6ce7e6,_0x2899fa,_0x1582d7){return _0x5bdc01(_0x6ce7e6,_0x2899fa,_0x1582d7);},'BVZZj':function(_0x14b8fe,_0x1f56b1){return _0x14b8fe===_0x1f56b1;},'UwyGx':_0x2e2cd8(0x3fd,0x379),'aOGEu':function(_0x4f48af,_0x4a76c1,_0x19edac,_0x1b2d9d){return _0x4f48af(_0x4a76c1,_0x19edac,_0x1b2d9d);},'Ttqpa':_0x2e2cd8(0x4c5,0x427),'RLDOA':function(_0x6d5df4,_0x208660,_0x22a0d0){return _0x6d5df4(_0x208660,_0x22a0d0);},'BXjkT':_0x2e2cd8(0x387,0x3eb),'npxBx':function(_0x5a9e08,_0x2d5bd7,_0x4305eb,_0x280b67){return _0x5a9e08(_0x2d5bd7,_0x4305eb,_0x280b67);},'ueyHS':function(_0x5cfddf,_0x3a2166,_0x4f2255){return _0x5cfddf(_0x3a2166,_0x4f2255);},'mDhhY':_0x2e2cd8(0x47c,0x41f),'ORQXY':function(_0x387c51,_0x5796b3){return _0x387c51===_0x5796b3;},'wjZsF':_0x2e2cd8(0x3e5,0x3da),'jNRSV':function(_0x146db7,_0x197dc5,_0x47a416,_0x2d1587){return _0x146db7(_0x197dc5,_0x47a416,_0x2d1587);},'tHagz':_0x2e2cd8(0x428,0x37d),'RimXp':function(_0xce149c,_0x4af5a6){return _0xce149c===_0x4af5a6;},'nopXD':_0x2e2cd8(0x497,0x460),'vVimL':function(_0xb990fd,_0x3f1e0a){return _0xb990fd===_0x3f1e0a;},'vnpLC':_0x2e2cd8(0x519,0x474),'joCXA':function(_0x15253a,_0x55b98d){return _0x15253a===_0x55b98d;},'LzDDk':_0x2e2cd8(0x3da,0x387),'AprRW':_0x2e2cd8(0x474,0x3f1),'NmWqs':function(_0x6a9798,_0x3b8830){return _0x6a9798===_0x3b8830;},'URmoO':_0x2e2cd8(0x3fb,0x3bc)};function _0x2e2cd8(_0x561545,_0xb15bdf){return a0_0x4d8ed7(_0x561545,_0xb15bdf-0x26d);}let _0x33059f=_0x289c01[_0x2e2cd8(0x370,0x377)][_0x2e2cd8(0x3ac,0x3a1)](tabPortRegex);if(_0x33059f){let _0x4ba4e8=+_0x33059f[0x2];if(_0x484983[_0x2e2cd8(0x467,0x424)](_0x33059f[0x1],_0x484983['tHagz'])){if(_0x484983[_0x2e2cd8(0x410,0x483)](_0x484983[_0x2e2cd8(0x40a,0x49b)],_0x484983[_0x2e2cd8(0x472,0x49b)]))augmentedDomMessageContainer[_0x2e2cd8(0x40e,0x421)][_0x4ba4e8]=_0x289c01,_0x289c01[_0x2e2cd8(0x40a,0x3cf)][_0x2e2cd8(0x411,0x3dc)](()=>{function _0x102b0a(_0x121023,_0x296576){return _0x2e2cd8(_0x296576,_0x121023- -0x3c5);}augmentedDomMessageContainer[_0x102b0a(0xf,-0x3c)][_0x4ba4e8]=_0x484983[_0x102b0a(0x81,0xa4)](mergeArrays,augmentedDomMessageContainer['cache'][_0x4ba4e8],augmentedDomMessageContainer[_0x102b0a(0x75,0x11f)][_0x4ba4e8]);}),_0x289c01['onMessage'][_0x2e2cd8(0x367,0x3dc)]((_0x16e4f6,_0x1a74c9,_0x430c42)=>{function _0x432918(_0x12f658,_0x35826e){return _0x2e2cd8(_0x35826e,_0x12f658- -0x577);}if(_0x484983[_0x432918(-0x153,-0x201)](_0x16e4f6[_0x432918(-0x1b1,-0x1cd)],_0x432918(-0x169,-0x1f9))){if(_0x484983[_0x432918(-0xc9,-0x55)](_0x484983[_0x432918(-0x170,-0x1ee)],_0x484983['KdBZe']))return!_0x4af3a[_0x649b70]&&(_0x46995c[_0x94063d]=[]),_0x580792[_0x3ca8a4][_0x432918(-0x1c8,-0x1c8)](0x0,_0x4b71f8);else emptySpecificMessageArray(_0x4ba4e8,augmentedDomMessageContainer['cache']),_0x484983[_0x432918(-0x131,-0x168)](emptySpecificMessageArray,_0x4ba4e8,augmentedDomMessageContainer[_0x432918(-0x13d,-0x121)]),_0x484983['sOeGB'](resetBadge,_0x4ba4e8);}});else for(const [_0x1fdc67,_0x100305]of _0x30543a[_0x2e2cd8(0x3cb,0x3f6)](_0x565136)){_0x5d4053[_0x2e2cd8(0x3d9,0x487)](_0x100305)&&_0x484983[_0x2e2cd8(0x37e,0x3e9)](_0x906097,_0x100305);}}else{if(_0x484983['vVimL'](_0x33059f[0x1],_0x484983[_0x2e2cd8(0x381,0x395)])){if(_0x484983['joCXA'](_0x484983['LzDDk'],_0x484983['AprRW'])){const _0x4f077a=_0x484983['fDggV'][_0x2e2cd8(0x41a,0x432)]('|');let _0x4e9b02=0x0;while(!![]){switch(_0x4f077a[_0x4e9b02++]){case'0':_0x4851b4=_0x382e7d[_0x2e2cd8(0x3ad,0x444)];continue;case'1':_0x545b89=_0x3b4460[_0x2e2cd8(0x4e3,0x473)];continue;case'2':_0x254199=_0x1db794[_0x2e2cd8(0x327,0x38a)];continue;case'3':_0x570534=_0x5500ca[_0x2e2cd8(0x3bb,0x3a7)];continue;case'4':_0x524fb9=_0x364472['canary'];continue;case'5':_0x33aca7=_0x10f62f['prototypePollutionCSP'];continue;}break;}}else postMessageContainer['ports'][_0x4ba4e8]=_0x289c01,_0x289c01[_0x2e2cd8(0x42e,0x3cf)][_0x2e2cd8(0x48b,0x3dc)](()=>{function _0x112199(_0x550d31,_0x2e4699){return _0x2e2cd8(_0x550d31,_0x2e4699- -0x28b);}postMessageContainer['cache'][_0x4ba4e8]=_0x484983[_0x112199(0x25e,0x1ca)](mergeArrays,postMessageContainer['cache'][_0x4ba4e8],postMessageContainer['history'][_0x4ba4e8]);}),_0x289c01[_0x2e2cd8(0x3e6,0x390)][_0x2e2cd8(0x48d,0x3dc)]((_0x741ecb,_0x228d1e,_0x42e806)=>{function _0x55da0f(_0x552e70,_0x28b21d){return _0x2e2cd8(_0x552e70,_0x28b21d- -0x58c);}_0x484983[_0x55da0f(-0x2f,-0xde)](_0x484983[_0x55da0f(-0x144,-0x123)],_0x55da0f(-0x237,-0x1d4))?(_0x484983[_0x55da0f(-0x12a,-0x1cf)](_0x2b9782,_0x3e9b23,_0x98a5ab,+_0x2ac1fc),_0x442f02[_0x55da0f(-0x189,-0x214)][_0x4b0455]=!![]):_0x741ecb[_0x55da0f(-0x1ab,-0x1c6)]===_0x484983['YdHUA']&&(_0x484983[_0x55da0f(-0x1b8,-0x10e)](emptySpecificMessageArray,_0x4ba4e8,postMessageContainer[_0x55da0f(-0x15c,-0x1b8)]),emptySpecificMessageArray(_0x4ba4e8,postMessageContainer['history']),_0x484983[_0x55da0f(-0x14d,-0x1a3)](resetBadge,_0x4ba4e8));});}}}else _0x484983[_0x2e2cd8(0x517,0x4aa)](_0x289c01['name'],_0x484983[_0x2e2cd8(0x444,0x39f)])&&_0x289c01[_0x2e2cd8(0x360,0x390)][_0x2e2cd8(0x418,0x3dc)]((_0x1a241c,_0x49a11d,_0x2a55fc)=>{function _0x4a0b09(_0x2a897d,_0x42688c){return _0x2e2cd8(_0x2a897d,_0x42688c- -0x7f);}if(_0x484983['HDlCh'](_0x1a241c[_0x4a0b09(0x3a4,0x347)],_0x484983['znUqP'])&&_0x49a11d&&_0x49a11d[_0x4a0b09(0x38e,0x31d)]&&_0x49a11d[_0x4a0b09(0x307,0x31d)][_0x4a0b09(0x385,0x333)])_0x484983[_0x4a0b09(0x41c,0x3a5)](_0x484983[_0x4a0b09(0x39e,0x346)],_0x484983['loAeO'])?_0x484983[_0x4a0b09(0x425,0x3d9)](pushToArray,_0x49a11d[_0x4a0b09(0x2f5,0x31d)][_0x4a0b09(0x3d5,0x333)]['id'],_0x289c01,connections):_0x529a34=_0x2d96ca['prototypePollutionCSP'][_0x4a0b09(0x4c2,0x44a)];else{if(_0x1a241c['messageType']==='collectData')_0x1a241c[_0x4a0b09(0x31a,0x3ae)]&&_0x484983[_0x4a0b09(0x397,0x324)](_0x1a241c[_0x4a0b09(0x334,0x3ae)],_0x484983['uQtOk'])&&_0x49a11d&&_0x49a11d['sender']&&_0x49a11d[_0x4a0b09(0x35a,0x31d)][_0x4a0b09(0x358,0x333)]&&addToQueue(_0x1a241c,augmentedDomMessageContainer,_0x49a11d[_0x4a0b09(0x2fa,0x31d)]['tab']['id']);else{if(_0x484983[_0x4a0b09(0x39f,0x3a5)](_0x1a241c[_0x4a0b09(0x2ee,0x347)],_0x484983[_0x4a0b09(0x33e,0x304)])){let _0x5ea4a6=_0x1a241c[_0x4a0b09(0x2b1,0x305)];if(augmentedDomMessageContainer[_0x4a0b09(0x31d,0x355)][_0x5ea4a6]&&!augmentedDomMessageContainer['cache'][_0x5ea4a6][_0x4a0b09(0x3f2,0x3d8)])return;_0x484983[_0x4a0b09(0x449,0x3ef)](postMessageOverPort,_0x5ea4a6,{'messageType':_0x484983[_0x4a0b09(0x381,0x3bd)],'messageCache':_0x484983[_0x4a0b09(0x465,0x3e8)](takeElementsFromArray,augmentedDomMessageContainer[_0x4a0b09(0x36d,0x355)],_0x5ea4a6)},augmentedDomMessageContainer[_0x4a0b09(0x42e,0x3a2)])&&_0x484983[_0x4a0b09(0x45d,0x3c7)](reduceSpecificMessageCache,_0x5ea4a6,augmentedDomMessageContainer[_0x4a0b09(0x2ed,0x355)]);}else{if(_0x1a241c['messageType']===_0x484983[_0x4a0b09(0x402,0x358)]){let _0x15d177=_0x1a241c[_0x4a0b09(0x306,0x305)];if(postMessageContainer[_0x4a0b09(0x360,0x355)][_0x15d177]&&!postMessageContainer[_0x4a0b09(0x2fd,0x355)][_0x15d177][_0x4a0b09(0x44e,0x3d8)])return;_0x484983['npxBx'](postMessageOverPort,_0x15d177,{'messageType':_0x484983[_0x4a0b09(0x369,0x3bd)],'messageCache':_0x484983[_0x4a0b09(0x3c8,0x3d6)](takeElementsFromArray,postMessageContainer[_0x4a0b09(0x325,0x355)],_0x15d177)},postMessageContainer[_0x4a0b09(0x2fa,0x3a2)])&&_0x484983[_0x4a0b09(0x4a6,0x43e)](reduceSpecificMessageCache,_0x15d177,postMessageContainer[_0x4a0b09(0x2db,0x355)]);}else _0x484983[_0x4a0b09(0x384,0x324)](_0x1a241c[_0x4a0b09(0x2e5,0x347)],_0x484983['mDhhY'])&&(_0x1a241c[_0x4a0b09(0x43e,0x3ae)]&&_0x484983[_0x4a0b09(0x304,0x3a5)](_0x1a241c[_0x4a0b09(0x437,0x3ae)],_0x484983[_0x4a0b09(0x3a5,0x3f1)])&&_0x49a11d&&_0x49a11d['sender']&&_0x49a11d[_0x4a0b09(0x2ed,0x31d)][_0x4a0b09(0x2a8,0x333)]&&(_0x484983['ORQXY'](_0x484983[_0x4a0b09(0x494,0x424)],_0x4a0b09(0x2f9,0x356))?_0x583428[_0x4a0b09(0x314,0x3ae)]&&_0x484983['SQkPg'](_0x3e2318[_0x4a0b09(0x419,0x3ae)],_0x484983[_0x4a0b09(0x482,0x3f1)])&&_0xa93ecf&&_0x10ac9d[_0x4a0b09(0x3c3,0x31d)]&&_0x22328a['sender'][_0x4a0b09(0x350,0x333)]&&_0x13d0fe(_0x563499,_0x2ee335,_0x5bc64a['sender']['tab']['id']):_0x484983['jNRSV'](addToQueue,_0x1a241c,postMessageContainer,_0x49a11d[_0x4a0b09(0x292,0x31d)][_0x4a0b09(0x289,0x333)]['id'])));}}}});}),chrome[a0_0x4d8ed7(0x17d,0x197)][a0_0x4d8ed7(0x73,0x123)][a0_0x4d8ed7(0xf0,0x16f)]((_0x50fc24,_0x125979,_0x5f4326)=>{function _0x386995(_0x4474ad,_0x1cee37){return a0_0x4d8ed7(_0x1cee37,_0x4474ad-0x3b4);}const _0x3eed11={'dRPAS':function(_0x45afa6,_0x5d3d9){return _0x45afa6(_0x5d3d9);},'fXKfY':_0x386995(0x614,0x5a3),'DgBuM':_0x386995(0x60e,0x61b),'vrfqB':_0x386995(0x585,0x4fe),'gwaiQ':function(_0x25d51e,_0x19f6a3){return _0x25d51e===_0x19f6a3;},'SpAPP':function(_0x1caed5,_0x161061){return _0x1caed5===_0x161061;},'YMovT':_0x386995(0x514,0x522),'lzyuN':_0x386995(0x4d6,0x4f9),'wYmXl':function(_0x4c86fa,_0x552072){return _0x4c86fa===_0x552072;},'jEVeV':_0x386995(0x596,0x5d3),'bSauc':_0x386995(0x53a,0x5aa),'ZRPmZ':_0x386995(0x5aa,0x505)};if(_0x50fc24===_0x3eed11[_0x386995(0x4de,0x433)]){if(_0x3eed11['vrfqB']===_0x3eed11['vrfqB']){if(_0x3eed11[_0x386995(0x4df,0x4be)](_0x125979[_0x386995(0x550,0x5c6)],0x0)){if(_0x3eed11[_0x386995(0x513,0x519)](_0x3eed11[_0x386995(0x580,0x55d)],_0x3eed11[_0x386995(0x5d2,0x63a)]))_0x5c3272[_0x426d16]=[];else{let _0x5a6ca1=_0x125979[_0x386995(0x4f9,0x55d)]['id'];for(let _0x173c38 of panelContainers){_0x3eed11[_0x386995(0x4f1,0x449)](_0x3eed11['jEVeV'],_0x3eed11['jEVeV'])?postMessageOverPort(_0x5a6ca1,{'messageType':_0x3eed11[_0x386995(0x608,0x6a1)]},_0x173c38[_0x386995(0x568,0x559)]):_0x3eed11[_0x386995(0x582,0x60a)](_0x238c0f,_0x45b95b);}}}_0x3eed11[_0x386995(0x582,0x5be)](_0x5f4326,{'type':'DOMINVADER_PONG','message':_0x3eed11[_0x386995(0x59d,0x518)]});}else _0x4471f9[_0x386995(0x554,0x5b7)](_0x3eed11[_0x386995(0x4b7,0x47b)],![]),_0x20790c=_0x4e584c['toJson'](),_0x3ef03c(_0x22f9ea[_0x386995(0x4cb,0x4a0)]),/^https?:\/\//[_0x386995(0x512,0x478)](_0x48146c[_0x386995(0x5f8,0x599)])&&_0x21d223['scripting'][_0x386995(0x4b9,0x51b)]({'target':{'tabId':_0x38157d[_0x386995(0x4cb,0x55a)],'allFrames':!![]},'func':_0x32162e,'args':[_0x33459d],'injectImmediately':!![],'world':_0x386995(0x565,0x512)});}});function sendSettings(_0x2e8088){try{window.localStorage.setItem('DOMInvaderSettings',_0x2e8088);}catch(e){}}chrome[a0_0x4d8ed7(0x24b,0x256)][a0_0x4d8ed7(0x1af,0x232)][a0_0x4d8ed7(0x154,0x16f)](function(_0x5db76f){const _0xa6d686={'cpuSp':function(_0x4b0728,_0xeea154){return _0x4b0728===_0xeea154;},'mkRTk':'browserReloadRequired','kDOch':function(_0x5543d4,_0xf0cef7){return _0x5543d4(_0xf0cef7);},'oXUKy':_0x1b963d(0x313,0x270)};function _0x1b963d(_0x39ca86,_0x4153ba){return a0_0x4d8ed7(_0x39ca86,_0x4153ba-0xbf);}_0xa6d686[_0x1b963d(0x234,0x291)](_0x5db76f[_0x1b963d(0x231,0x25b)],0x0)&&(settings[_0x1b963d(0x2c3,0x25f)](_0xa6d686[_0x1b963d(0x318,0x312)],![]),settingsJson=settings['toJson'](),_0xa6d686[_0x1b963d(0x365,0x30e)](emptyMessages,_0x5db76f['tabId']),/^https?:\/\//['test'](_0x5db76f[_0x1b963d(0x2a7,0x303)])&&chrome[_0x1b963d(0x203,0x27a)][_0x1b963d(0x146,0x1c4)]({'target':{'tabId':_0x5db76f[_0x1b963d(0x21a,0x1d6)],'allFrames':!![]},'func':sendSettings,'args':[settingsJson],'injectImmediately':!![],'world':_0xa6d686[_0x1b963d(0x24e,0x2b8)]}));}),chrome[a0_0x4d8ed7(0x14e,0x166)][a0_0x4d8ed7(0x265,0x1b8)][a0_0x4d8ed7(0xf0,0x16f)](_0x19a3b7=>{const _0xeb9e0b={'EToLz':function(_0x51ac85,_0x56e486){return _0x51ac85(_0x56e486);}};function _0x3b39ea(_0x585da3,_0xda13a7){return a0_0x4d8ed7(_0xda13a7,_0x585da3-0x342);}_0xeb9e0b[_0x3b39ea(0x4e8,0x43d)](destroyMessageObjects,_0x19a3b7);}),chrome[a0_0x4d8ed7(0x1e5,0x166)][a0_0x4d8ed7(0x241,0x1c1)][a0_0x4d8ed7(0xc7,0x16f)]((_0x4164c1,_0x52ad58)=>{destroyMessageObjects(_0x52ad58);}),chrome[a0_0x4d8ed7(0x1a8,0x197)][a0_0x4d8ed7(0x100,0x152)]['addListener'](_0x5ee461=>{const _0x7228df={'CvJsd':function(_0x21e21d,_0x53cdc3){return _0x21e21d===_0x53cdc3;},'AFEwS':_0x2047aa(-0xd1,-0x7d),'ZSlRv':function(_0x38b17e,_0x149b35){return _0x38b17e+_0x149b35;},'sEhRL':function(_0x474e7a,_0x2794af){return _0x474e7a*_0x2794af;},'Bupwa':function(_0x52f546,_0x3ecc83){return _0x52f546-_0x3ecc83;}};function _0x2047aa(_0x58b9ae,_0x3f6a2e){return a0_0x4d8ed7(_0x3f6a2e,_0x58b9ae- -0x334);}_0x7228df['CvJsd'](_0x5ee461[_0x2047aa(-0x1de,-0x230)],'install')&&settings[_0x2047aa(-0x194,-0x226)](_0x7228df[_0x2047aa(-0x1c8,-0x17c)],_0x7228df[_0x2047aa(-0x21f,-0x2bc)](String[_0x2047aa(-0x1c4,-0x24b)](Math['floor'](_0x7228df[_0x2047aa(-0x1f6,-0x27d)](Math[_0x2047aa(-0x1a5,-0xf5)](),_0x7228df[_0x2047aa(-0x21f,-0x1e3)](_0x7228df[_0x2047aa(-0x1a7,-0x230)](0x7a,0x61),0x1))+0x61)),Math[_0x2047aa(-0x1a5,-0x179)]()[_0x2047aa(-0x1b4,-0x245)](0x24)['slice'](-0x7)));}),chrome[a0_0x4d8ed7(0x22e,0x197)]['onStartup']['addListener'](()=>{updateDOMInvaderRules();});function updateDOMInvaderRules(){const _0x386a5d={'bpuNw':function(_0x123f34,_0x46f74a,_0x33c3a5){return _0x123f34(_0x46f74a,_0x33c3a5);},'LVzjG':_0x375fdc(0x14,0x26),'yjcoP':_0x375fdc(0x3c,-0x59),'lzsWf':_0x375fdc(-0x67,-0xa6),'ujaAm':function(_0x56129e,_0x44214e){return _0x56129e!==_0x44214e;},'RVSAU':_0x375fdc(-0xb9,-0x5e),'gnkEp':_0x375fdc(-0x4d,-0x80),'cgZuR':'ToerZ','WyBFY':_0x375fdc(0x28,0x58),'OucdL':_0x375fdc(0x40,0x37),'OIFMe':_0x375fdc(-0x50,-0xdb),'XfXos':'x-frame-options','nhoDf':function(_0x11eb97,_0x5d4d10){return _0x11eb97===_0x5d4d10;},'eHpJG':_0x375fdc(0x2e,-0x71),'BHkLk':_0x375fdc(-0x59,-0x33),'RFNUx':_0x375fdc(-0x105,-0x139)},_0x2bdce6=[],_0x3e982a=[];chrome[_0x375fdc(0xb,0x2b)][_0x375fdc(-0x71,-0x8a)]({'removeRuleIds':[0x1,0x2,0x3]},()=>{function _0x50394c(_0x4bfd79,_0x41b96e){return _0x375fdc(_0x41b96e-0x14f,_0x4bfd79);}console[_0x50394c(0x134,0xc6)]('Rules\x20updated');});prototypePollutionCSP?'eOqKC'===_0x386a5d[_0x375fdc(-0x108,-0x175)]?_0x36d89e[_0x375fdc(-0xb0,-0x76)][_0x339900]['interesting']=!![]:_0x2bdce6[_0x375fdc(-0x34,-0x87)]({'id':0x1,'priority':0x1,'action':{'type':_0x375fdc(-0x50,-0x8),'responseHeaders':[{'header':_0x386a5d[_0x375fdc(-0x5e,-0x4)],'operation':_0x386a5d[_0x375fdc(-0x43,-0x6c)]}]},'condition':{'urlFilter':'*','resourceTypes':[_0x386a5d[_0x375fdc(-0x104,-0x14a)],_0x386a5d['OucdL']]}}):_0x3e982a[_0x375fdc(-0x34,-0xa0)](0x1);function _0x375fdc(_0x5105b7,_0x411118){return a0_0x4d8ed7(_0x411118,_0x5105b7- -0x20c);}prototypePollutionXFrameOptions?_0x2bdce6[_0x375fdc(-0x34,-0x33)]({'id':0x2,'priority':0x1,'action':{'type':_0x386a5d[_0x375fdc(-0x2c,0x14)],'responseHeaders':[{'header':_0x386a5d[_0x375fdc(-0xc,-0x27)],'operation':_0x375fdc(0x28,-0x26)}]},'condition':{'urlFilter':'*','resourceTypes':[_0x386a5d[_0x375fdc(-0x104,-0xb8)],_0x375fdc(0x40,0x81)]}}):_0x386a5d[_0x375fdc(-0x1a,0x47)](_0x386a5d[_0x375fdc(0x53,0xee)],_0x375fdc(0x2e,0xcb))?_0x3e982a[_0x375fdc(-0x34,-0x1f)](0x2):_0x401eb7['cache'][_0x4a8d5b]=_0x386a5d[_0x375fdc(-0x99,-0x55)](_0x1fbbe5,_0x58810d[_0x375fdc(-0xa5,0xa)][_0x344659],_0x137ef7['history'][_0xa3aeff]),permissionsPolicy?_0x2bdce6['push']({'id':0x3,'priority':0x1,'action':{'type':_0x386a5d[_0x375fdc(-0x2c,0x1)],'responseHeaders':[{'header':_0x386a5d[_0x375fdc(-0xf9,-0xe3)],'operation':_0x386a5d[_0x375fdc(-0x43,-0x88)]}]},'condition':{'urlFilter':'*','resourceTypes':[_0x386a5d[_0x375fdc(-0x104,-0xd0)],_0x386a5d[_0x375fdc(0x42,-0x48)]]}}):_0x386a5d[_0x375fdc(-0x1a,0x30)](_0x375fdc(-0xc8,-0x7d),_0x386a5d[_0x375fdc(-0x36,0x51)])?_0x2e2ab7[_0x375fdc(-0x89,0x1e)](_0x386a5d[_0x375fdc(0x4f,0x1d)],_0x2c7b5b[_0x375fdc(-0x75,-0x8e)][_0x375fdc(0x18,0x75)]):_0x3e982a[_0x375fdc(-0x34,0x60)](0x3),chrome[_0x375fdc(0xb,-0x92)]['updateDynamicRules']({'addRules':_0x2bdce6,'removeRuleIds':_0x3e982a},()=>{function _0x287411(_0x4f8fe5,_0x283882){return _0x375fdc(_0x4f8fe5-0x323,_0x283882);}const _0x30a2d9={'yQyTh':_0x386a5d['yjcoP'],'rLewJ':_0x386a5d[_0x287411(0x21f,0x2b7)]};_0x386a5d[_0x287411(0x28f,0x2ec)](_0x287411(0x26a,0x1d5),_0x386a5d[_0x287411(0x2fc,0x2b6)])?_0x311225[_0x287411(0x2ef,0x352)]({'id':0x1,'priority':0x1,'action':{'type':_0x287411(0x2d3,0x347),'responseHeaders':[{'header':_0x30a2d9[_0x287411(0x362,0x39b)],'operation':_0x287411(0x34b,0x3ed)}]},'condition':{'urlFilter':'*','resourceTypes':[_0x30a2d9[_0x287411(0x2fd,0x395)],_0x287411(0x363,0x362)]}}):console[_0x287411(0x29a,0x32d)](_0x386a5d[_0x287411(0x2d5,0x34b)]);});}
chrome.runtime.onInstalled.addListener(reason => {
    updateIcon();
});