"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageIsDevDependency = void 0;
const path_1 = require("./path");
const fs_1 = require("fs");
function packageIsDevDependency({ appPath, packageDetails, }) {
    const packageJsonPath = path_1.join(appPath, "package.json");
    if (!fs_1.existsSync(packageJsonPath)) {
        return false;
    }
    const { devDependencies } = require(packageJsonPath);
    return Boolean(devDependencies && devDependencies[packageDetails.packageNames[0]]);
}
exports.packageIsDevDependency = packageIsDevDependency;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFja2FnZUlzRGV2RGVwZW5kZW5jeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9wYWNrYWdlSXNEZXZEZXBlbmRlbmN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLGlDQUE2QjtBQUM3QiwyQkFBK0I7QUFFL0IsU0FBZ0Isc0JBQXNCLENBQUMsRUFDckMsT0FBTyxFQUNQLGNBQWMsR0FJZjtJQUNDLE1BQU0sZUFBZSxHQUFHLFdBQUksQ0FBQyxPQUFPLEVBQUUsY0FBYyxDQUFDLENBQUE7SUFDckQsSUFBSSxDQUFDLGVBQVUsQ0FBQyxlQUFlLENBQUMsRUFBRTtRQUNoQyxPQUFPLEtBQUssQ0FBQTtLQUNiO0lBQ0QsTUFBTSxFQUFFLGVBQWUsRUFBRSxHQUFHLE9BQU8sQ0FBQyxlQUFlLENBQUMsQ0FBQTtJQUNwRCxPQUFPLE9BQU8sQ0FBQyxlQUFlLElBQUksZUFBZSxDQUFDLGNBQWMsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFBO0FBQ3BGLENBQUM7QUFiRCx3REFhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBhdGNoZWRQYWNrYWdlRGV0YWlscyB9IGZyb20gXCIuL1BhY2thZ2VEZXRhaWxzXCJcbmltcG9ydCB7IGpvaW4gfSBmcm9tIFwiLi9wYXRoXCJcbmltcG9ydCB7IGV4aXN0c1N5bmMgfSBmcm9tIFwiZnNcIlxuXG5leHBvcnQgZnVuY3Rpb24gcGFja2FnZUlzRGV2RGVwZW5kZW5jeSh7XG4gIGFwcFBhdGgsXG4gIHBhY2thZ2VEZXRhaWxzLFxufToge1xuICBhcHBQYXRoOiBzdHJpbmdcbiAgcGFja2FnZURldGFpbHM6IFBhdGNoZWRQYWNrYWdlRGV0YWlsc1xufSkge1xuICBjb25zdCBwYWNrYWdlSnNvblBhdGggPSBqb2luKGFwcFBhdGgsIFwicGFja2FnZS5qc29uXCIpXG4gIGlmICghZXhpc3RzU3luYyhwYWNrYWdlSnNvblBhdGgpKSB7XG4gICAgcmV0dXJuIGZhbHNlXG4gIH1cbiAgY29uc3QgeyBkZXZEZXBlbmRlbmNpZXMgfSA9IHJlcXVpcmUocGFja2FnZUpzb25QYXRoKVxuICByZXR1cm4gQm9vbGVhbihkZXZEZXBlbmRlbmNpZXMgJiYgZGV2RGVwZW5kZW5jaWVzW3BhY2thZ2VEZXRhaWxzLnBhY2thZ2VOYW1lc1swXV0pXG59XG4iXX0=