<!---
#
# KIM-API: An API for interatomic models
# Copyright (c) 2013--2022, Regents of the University of Minnesota.
# All rights reserved.
#
# Contributors:
#    Ryan S. Elliott
#    Ellad B. Tadmor
#
# SPDX-License-Identifier: LGPL-2.1-or-later
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#

#
# Release: This file is part of the kim-api.git repository.
#
-->

[![Build](https://github.com/openkim/kim-api/actions/workflows/build-multiplatform.yml/badge.svg)](https://github.com/openkim/kim-api/actions/workflows/build-multiplatform.yml)
[![Documentation Status](https://readthedocs.org/projects/kim-api/badge/?version=devel)](https://kim-api.readthedocs.io/en/devel/?badge=devel)
[![Coverity Scan](https://scan.coverity.com/projects/16411/badge.svg?flat=1)](https://scan.coverity.com/projects/openkim-kim-api)
[![codecov](https://codecov.io/gh/openkim/kim-api/branch/devel/graph/badge.svg)](https://codecov.io/gh/openkim/kim-api/branch/devel)

<p align="center"><h2>The KIM API package</h2></p>

<a href="https://repology.org/project/kim-api/versions"><img src="https://repology.org/badge/vertical-allrepos/kim-api.svg" alt="Packaging status" align="right" style="padding:5px;"/></a>

The KIM API package is a system-level library that aims to give computer
programmers the ability to write atomistic or molecular simulation programs
that can seamlessly interface with implementations of interatomic models,
regardless of the programming language (C, C++, Fortran, Python, etc.) in which
the codes are written.  It is part of the larger KIM project
(https://openkim.org).


Documentation
-------------

[Full documentation](https://kim-api.readthedocs.io/en/devel) is available online via [readthedocs.org](https://readthedocs.org)


Download
--------

All official release archives of the KIM API package can be downloaded from:

[https://openkim.org/kim-api/previous-versions](https://openkim.org/kim-api/previous-versions)

Release notes are available in the [NEWS](NEWS) file.


Installation
------------

See the [INSTALL](INSTALL) file for instructions on how to build and install
the package and its documentation.


Contributing
------------

Just send us a [pull request](https://help.github.com/articles/using-pull-requests/).
When you send your request, make `devel` the destination branch on the
[kim-api repository](https://github.com/openkim/kim-api).

Please see the [README_GIT](README_GIT) file for some additional details.


Issues, bugs, requests, ideas
-----------------------------

Use the [issues](https://github.com/openkim/kim-api/issues) tracker to report
bugs.


License
-------

The KIM API is distributed under the terms of the LGPL-2.1-or-later
license.

All new contributions must be made under this license.

See [LICENSE.LGPL](LICENSE.LGPL) and
[https://spdx.org/licenses/LGPL-2.1-or-later.html](https://spdx.org/licenses/LGPL-2.1-or-later.html)
for details.


*******************************************************************************

SUPPORT

Support is always available by posting questions with all relevant information
to

<https://matsci.org/openkim>

Members of the OpenKIM development team actively monitor this forum and
will do their best to respond to questions in a timely fashion.

*******************************************************************************
