#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "review", "leaveReviewOnScreenChange"
        ):
            return
        self.env["runtime"]["CursorManager"].clear_review_cursor()

    def set_callback(self, callback):
        pass
