#ifndef EDLINE_H
#define EDLINE_H

#include "misc.h"
#include "xio.h"

#define EDLEN 128

typedef void (*edline_exit_func_t)(void *exit_data, u8 *buf);

struct edline
{
    struct xio_win *xw;
    const u8 *prompt;
    edline_exit_func_t exit_func;
    void *exit_data;
    xio_win_handler_t old_handler;
    void *old_data;

    u8 buf[EDLEN];
    int plen;		// prompt len
    int len;		// current len (excl prompt)
    int offs;		// current scroll offset
};

struct edline *edline_new(struct xio_win *xw, const u8 *prompt, const u8 *preset,
                          edline_exit_func_t exit_func, void *exit_data);
void edline_abort(struct edline *el);

#endif
