/***********************************************/
/**
* @file loopFileGnssStationInfo.h
*
* @brief DEPRECATDED. Use LoopPlatformEquipment instead.
*
* @author Sebastian Strasser
* @date 2018-01-29
*
*/
/***********************************************/

#ifndef __GROOPS_LOOPFILEGNSSSTATIONINFO__
#define __GROOPS_LOOPFILEGNSSSTATIONINFO__

// Latex documentation
#ifdef DOCSTRING_Loop
static const char *docstringLoopFileGnssStationInfo = R"(
\subsection{FileGnssStationInfo}
DEPRECATDED. Use LoopPlatformEquipment instead.
)";
#endif

/***********************************************/

#include "base/import.h"
#include "classes/loop/loop.h"
#include "files/filePlatform.h"

/***** CLASS ***********************************/

/** @brief DEPRECATDED. Use LoopPlatformEquipment instead.
* @ingroup loopGroup
* @see Loop */
class LoopFileGnssStationInfo : public Loop
{
  Platform                platform;
  PlatformEquipment::Type type;
  std::string             nameName, nameSerial, nameInfo, nameTimeStart, nameTimeEnd;
  std::string             nameIndex, nameCount;

public:
  LoopFileGnssStationInfo(Config &config);

  UInt count() const override {return std::count_if(platform.equipments.begin(), platform.equipments.end(), [&](const auto &x)
                                                   {return (x->getType() == type);});}
  Bool iteration(VariableList &varList) override;
};

/***********************************************/
/***** Inlines *********************************/
/***********************************************/

inline LoopFileGnssStationInfo::LoopFileGnssStationInfo(Config &config)
{
  try
  {
    FileName    fileName;
    std::string choice;

    readConfig(config, "inputfileGnssStationInfo", fileName, Config::MUSTSET, "", "station/transmitter info file");
    if(readConfigChoice(config, "infoType", choice, Config::MUSTSET, "", "info to loop over"))
    {
      if(readConfigChoiceElement(config, "antenna",  choice, "loop over antennas"))  type = PlatformEquipment::GNSSANTENNA;
      if(readConfigChoiceElement(config, "receiver", choice, "loop over receivers")) type = PlatformEquipment::GNSSRECEIVER;
      endChoice(config);
    }
    readConfig(config, "variableLoopName",      nameName,      Config::OPTIONAL,  "loopName",      "variable with antenna/receiver name");
    readConfig(config, "variableLoopSerial",    nameSerial,    Config::OPTIONAL,  "loopSerial",    "variable with antenna/receiver serial");
    readConfig(config, "variableLoopInfo",      nameInfo,      Config::OPTIONAL,  "loopInfo",      "variable with radome (antenna) or version (receiver)");
    readConfig(config, "variableLoopTimeStart", nameTimeStart, Config::OPTIONAL,  "loopTimeStart", "variable with antenna/receiver start time");
    readConfig(config, "variableLoopTimeEnd",   nameTimeEnd,   Config::OPTIONAL,  "loopTimeEnd",   "variable with antenna/receiver end time");
    readConfig(config, "variableLoopIndex",     nameIndex,     Config::OPTIONAL,  "",              "variable with index of current iteration (starts with zero)");
    readConfig(config, "variableLoopCount",     nameCount,     Config::OPTIONAL,  "",              "variable with total number of iterations");
    readConfigCondition(config);
    if(isCreateSchema(config)) return;

    logWarningOnce<<"LoopFileGnssStationInfo is DEPRECATDED. Use LoopPlatformEquipment instead."<<Log::endl;

    readFilePlatform(fileName, platform);
  }
  catch(std::exception &e)
  {
    GROOPS_RETHROW(e)
  }
}

/***********************************************/

inline Bool LoopFileGnssStationInfo::iteration(VariableList &varList)
{
  if(index() >= count())
    return FALSE;

  UInt idx = 0;
  for(const auto &eq : platform.equipments)
    if((eq->getType() == type) && (idx++ == index()))
    {
      if(!nameIndex.empty())     varList.setVariable(nameIndex,     index());
      if(!nameCount.empty())     varList.setVariable(nameCount,     count());
      if(!nameName.empty())      varList.setVariable(nameName,      eq->name);
      if(!nameSerial.empty())    varList.setVariable(nameSerial,    eq->serial);
      if(!nameTimeStart.empty()) varList.setVariable(nameTimeStart, eq->timeStart.mjd());
      if(!nameTimeEnd.empty())   varList.setVariable(nameTimeEnd,   eq->timeEnd.mjd());
      if(!nameInfo.empty())
      {
        switch(eq->getType())
        {
          case PlatformEquipment::GNSSANTENNA:  varList.setVariable(nameInfo, std::dynamic_pointer_cast<PlatformGnssAntenna>(eq)->radome); break;
          case PlatformEquipment::GNSSRECEIVER: varList.setVariable(nameInfo, std::dynamic_pointer_cast<PlatformGnssReceiver>(eq)->version); break;
          case PlatformEquipment::OTHER:        break;
          case PlatformEquipment::UNDEFINED:    break;
          default:                              break;
        }
      }
      break;
    }

  return checkCondition(varList);
}

/***********************************************/

#endif
